/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.provisioner;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.NativeUtils;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.common.StabilizerProperties;
import java.io.File;

public class Bash {
    private static final ILogger log = Logger.getLogger(Bash.class);
    private final String sshOptions;
    private final String user;

    public Bash(StabilizerProperties stabilizerProperties) {
        this.sshOptions = stabilizerProperties.get("SSH_OPTIONS");
        this.user = stabilizerProperties.get("USER");
    }

    public void execute(String command) {
        NativeUtils.execute(command);
    }

    public void copyToAgentStabilizerDir(String ip, String src, String target) {
        String syncCommand = String.format("rsync -av -e \"ssh %s\" %s %s@%s:hazelcast-stabilizer-%s/%s", this.sshOptions, src, this.user, ip, Utils.getVersion(), target);
        this.execute(syncCommand);
    }

    public void scpToRemote(String ip, File src, String target) {
        this.scpToRemote(ip, src.getAbsolutePath(), target);
    }

    public void scpToRemote(String ip, String src, String target) {
        String command = String.format("scp -r %s %s %s@%s:%s", this.sshOptions, src, this.user, ip, target);
        this.execute(command);
    }

    public void ssh(String ip, String command) {
        String sshCommand = String.format("ssh %s %s@%s \"%s\"", this.sshOptions, this.user, ip, command);
        this.execute(sshCommand);
    }

    public void sshQuiet(String ip, String command) {
        String sshCommand = String.format("ssh %s %s@%s \"%s\" || true", this.sshOptions, this.user, ip, command);
        this.execute(sshCommand);
    }
}

