/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.performance;

import com.hazelcast.stabilizer.performance.Performance;

public class OperationsPerSecond
implements Performance<OperationsPerSecond> {
    private long operations;
    private long startMs;
    private long endMs;

    public long getOperations() {
        return this.operations;
    }

    public void setOperations(long operations) {
        this.operations = operations;
    }

    public long getStartMs() {
        return this.startMs;
    }

    public void setStartMs(long startMs) {
        this.startMs = startMs;
    }

    public long getEndMs() {
        return this.endMs;
    }

    public void setEndMs(long endMs) {
        this.endMs = endMs;
    }

    @Override
    public OperationsPerSecond merge(OperationsPerSecond that) {
        OperationsPerSecond performance = new OperationsPerSecond();
        performance.setStartMs(Math.min(that.getStartMs(), this.getStartMs()));
        performance.setEndMs(Math.max(that.getEndMs(), this.getEndMs()));
        performance.setOperations(this.getOperations() + that.getOperations());
        return performance;
    }

    @Override
    public String toHumanString() {
        long timeMs = this.endMs - this.startMs;
        double performance = timeMs == 0L ? 0.0 : (double)this.operations * 1000.0 / (double)timeMs;
        StringBuffer sb = new StringBuffer();
        sb.append("Performance = ").append(performance).append(" ops/s ");
        return sb.toString();
    }
}

