/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.coordinator.remoting;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.FailureAlreadyThrownRuntimeException;
import com.hazelcast.stabilizer.agent.remoting.AgentRemoteService;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmSettings;
import com.hazelcast.stabilizer.common.AgentAddress;
import com.hazelcast.stabilizer.common.CountdownWatch;
import com.hazelcast.stabilizer.common.messaging.Message;
import com.hazelcast.stabilizer.common.messaging.MessageAddress;
import com.hazelcast.stabilizer.coordinator.remoting.AgentClient;
import com.hazelcast.stabilizer.tests.Failure;
import com.hazelcast.stabilizer.tests.TestSuite;
import com.hazelcast.stabilizer.worker.commands.Command;
import com.hazelcast.stabilizer.worker.commands.DoneCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AgentsClient {
    private static final ILogger log = Logger.getLogger(AgentsClient.class);
    private final List<AgentClient> agents = new LinkedList<AgentClient>();
    private final ExecutorService agentExecutor = Executors.newFixedThreadPool(100);

    public AgentsClient(List<AgentAddress> agentAddresses) {
        for (AgentAddress address : agentAddresses) {
            AgentClient client = new AgentClient(address);
            this.agents.add(client);
        }
    }

    public void start() {
        this.awaitAgentsReachable();
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AgentsClient.this.poke();
                }
            }
        }.start();
    }

    private void awaitAgentsReachable() {
        log.info("--------------------------------------------------------------");
        log.info("Waiting for agents to start");
        log.info("--------------------------------------------------------------");
        LinkedList<AgentClient> unchecked = new LinkedList<AgentClient>(this.agents);
        for (int k = 0; k < 12; ++k) {
            Iterator it = unchecked.iterator();
            while (it.hasNext()) {
                AgentClient agent = (AgentClient)it.next();
                try {
                    agent.execute(AgentRemoteService.Service.SERVICE_ECHO, "livecheck");
                    it.remove();
                    log.info("Connect to agent " + agent.publicAddress + " OK");
                }
                catch (Exception e) {
                    log.info("Connect to agent " + agent.publicAddress + " FAILED");
                    log.finest((Throwable)e);
                }
            }
            if (unchecked.isEmpty()) break;
            log.info("Sleeping 5 seconds and retrying unchecked agents");
            Utils.sleepSeconds(5);
        }
        this.agents.removeAll(unchecked);
        if (this.agents.isEmpty()) {
            log.info("--------------------------------------------------------------");
            Utils.exitWithError(log, "There are no reachable agents");
            log.info("--------------------------------------------------------------");
        }
        if (unchecked.isEmpty()) {
            log.info("--------------------------------------------------------------");
            log.info("All agents are reachable!");
            log.info("--------------------------------------------------------------");
            return;
        }
        StringBuilder sb = new StringBuilder("The Coordinator has dropped the following agents because they are not reachable:\n");
        for (AgentClient agent : unchecked) {
            sb.append("\t").append(agent.publicAddress).append("\n");
        }
        log.info("--------------------------------------------------------------");
        log.warning(sb.toString());
        log.info("--------------------------------------------------------------");
    }

    public int getAgentCount() {
        return this.agents.size();
    }

    public List<String> getPrivateAddresses() {
        LinkedList<String> result = new LinkedList<String>();
        for (AgentClient client : this.agents) {
            result.add(client.privateIp);
        }
        return result;
    }

    public List<String> getPublicAddresses() {
        LinkedList<String> result = new LinkedList<String>();
        for (AgentClient client : this.agents) {
            result.add(client.publicAddress);
        }
        return result;
    }

    public List<Failure> getFailures() {
        LinkedList<Future> futures = new LinkedList<Future>();
        for (final AgentClient agentClient : this.agents) {
            Future f = this.agentExecutor.submit(new Callable(){

                public Object call() throws Exception {
                    return agentClient.execute(AgentRemoteService.Service.SERVICE_GET_FAILURES, new Object[0]);
                }
            });
            futures.add(f);
        }
        LinkedList<Failure> result = new LinkedList<Failure>();
        for (Future f : futures) {
            try {
                List c = (List)f.get(30L, TimeUnit.SECONDS);
                result.addAll(c);
            }
            catch (InterruptedException e) {
                log.severe((Throwable)e);
            }
            catch (ExecutionException e) {
                log.severe((Throwable)e);
            }
            catch (TimeoutException e) {
                log.severe((Throwable)e);
            }
        }
        return result;
    }

    public void waitDone(String prefix, String testId) {
        long startTimeMs = System.currentTimeMillis();
        while (true) {
            List result = this.executeOnAllWorkers(new DoneCommand(testId));
            boolean complete = true;
            block1: for (List l : result) {
                for (Boolean b : l) {
                    if (b.booleanValue()) continue;
                    complete = false;
                    continue block1;
                }
            }
            if (complete) {
                return;
            }
            long durationMs = System.currentTimeMillis() - startTimeMs;
            log.info(prefix + "Waiting for completion: " + Utils.secondsToHuman(durationMs / 1000L));
            Utils.sleepSeconds(5);
        }
    }

    private <E> List<E> getAllFutures(Collection<Future> futures) {
        int value = Integer.parseInt(System.getProperty("worker.testmethod.timeout", "10000"));
        return this.getAllFutures(futures, TimeUnit.SECONDS.toMillis(value));
    }

    private <E> List<E> getAllFutures(Collection<Future> futures, long timeoutMs) {
        CountdownWatch watch = CountdownWatch.started(timeoutMs);
        LinkedList result = new LinkedList();
        for (Future future : futures) {
            try {
                Object o = future.get(watch.getRemainingMs(), TimeUnit.MILLISECONDS);
                result.add(o);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof FailureAlreadyThrownRuntimeException)) {
                    // empty if block
                }
                Utils.fixRemoteStackTrace(cause, Thread.currentThread().getStackTrace());
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void poke() {
        for (final AgentClient agentClient : this.agents) {
            this.agentExecutor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    agentClient.execute(AgentRemoteService.Service.SERVICE_POKE, new Object[0]);
                    return null;
                }
            });
        }
    }

    public void initTestSuite(final TestSuite testSuite) {
        LinkedList<Future> futures = new LinkedList<Future>();
        for (final AgentClient agentClient : this.agents) {
            Future f = this.agentExecutor.submit(new Callable(){

                public Object call() throws Exception {
                    agentClient.execute(AgentRemoteService.Service.SERVICE_INIT_TESTSUITE, testSuite);
                    return null;
                }
            });
            futures.add(f);
        }
        this.getAllFutures(futures);
    }

    public void terminateWorkers() {
        LinkedList<Future> futures = new LinkedList<Future>();
        for (final AgentClient agentClient : this.agents) {
            Future f = this.agentExecutor.submit(new Callable(){

                public Object call() throws Exception {
                    agentClient.execute(AgentRemoteService.Service.SERVICE_TERMINATE_WORKERS, new Object[0]);
                    return null;
                }
            });
            futures.add(f);
        }
        this.getAllFutures(futures);
    }

    public void spawnWorkers(final WorkerJvmSettings[] workerJvmSettingsArray) {
        LinkedList<Future> futures = new LinkedList<Future>();
        int k = 0;
        while (k < this.agents.size()) {
            final int index = k++;
            Future f = this.agentExecutor.submit(new Callable(){

                public Object call() throws Exception {
                    AgentClient agentClient = (AgentClient)AgentsClient.this.agents.get(index);
                    WorkerJvmSettings settings = workerJvmSettingsArray[index];
                    agentClient.execute(AgentRemoteService.Service.SERVICE_SPAWN_WORKERS, settings);
                    return null;
                }
            });
            futures.add(f);
        }
        this.getAllFutures(futures);
    }

    public void sendMessage(Message message) {
        List<Future> futures;
        log.info("Sending message '" + message + "' to address '" + message.getMessageAddress() + "'");
        MessageAddress messageAddress = message.getMessageAddress();
        if ("*".equals(messageAddress.getAgentAddress())) {
            futures = this.sendMessageToAllAgents(message);
        } else if ("R".equals(messageAddress.getAgentAddress())) {
            Future<Object> future = this.sendMessageToRandomAgent(message);
            futures = Arrays.asList(future);
        } else {
            throw new UnsupportedOperationException("Not Implemented yet");
        }
        this.getAllFutures(futures);
    }

    private Future<Object> sendMessageToRandomAgent(final Message message) {
        Random random = new Random();
        final AgentClient agentClient = this.getRandomAgentClientOrNull(random);
        if (agentClient == null) {
            throw new IllegalStateException("No agent exists. Is this a race condition?");
        }
        return this.agentExecutor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                agentClient.execute(AgentRemoteService.Service.SERVICE_PROCESS_MESSAGE, message);
                return null;
            }
        });
    }

    private AgentClient getRandomAgentClientOrNull(Random random) {
        if (this.agents.size() == 0) {
            return null;
        }
        return this.agents.get(random.nextInt(this.agents.size()));
    }

    private List<Future> sendMessageToAllAgents(final Message message) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (final AgentClient agentClient : this.agents) {
            Future<Object> future = this.agentExecutor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    agentClient.execute(AgentRemoteService.Service.SERVICE_PROCESS_MESSAGE, message);
                    return null;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public <E> List<String> getWorkers(final AgentClient agentClient) {
        Future<List<String>> future = this.agentExecutor.submit(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return (List)agentClient.execute(AgentRemoteService.Service.SERVICE_GET_ALL_WORKERS, new Object[0]);
            }
        });
        return this.getAllFutures(Arrays.asList(future));
    }

    public <E> List<E> executeOnAllWorkers(final Command command) {
        LinkedList<Future> futures = new LinkedList<Future>();
        for (final AgentClient agentClient : this.agents) {
            Future f = this.agentExecutor.submit(new Callable(){

                public Object call() throws Exception {
                    try {
                        return agentClient.execute(AgentRemoteService.Service.SERVICE_EXECUTE_ALL_WORKERS, command);
                    }
                    catch (RuntimeException t) {
                        log.severe((Throwable)t);
                        throw t;
                    }
                }
            });
            futures.add(f);
        }
        return this.getAllFutures(futures);
    }

    public void executeOnSingleWorker(final Command command) {
        if (this.agents.isEmpty()) {
            return;
        }
        Future f = this.agentExecutor.submit(new Callable(){

            public Object call() throws Exception {
                AgentClient agentClient = (AgentClient)AgentsClient.this.agents.get(0);
                return agentClient.execute(AgentRemoteService.Service.SERVICE_EXECUTE_SINGLE_WORKER, command);
            }
        });
        try {
            this.getAllFutures(Arrays.asList(f));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void echo(final String msg) {
        LinkedList<Future> futures = new LinkedList<Future>();
        for (final AgentClient agentClient : this.agents) {
            Future f = this.agentExecutor.submit(new Callable(){

                public Object call() throws Exception {
                    agentClient.execute(AgentRemoteService.Service.SERVICE_ECHO, msg);
                    return null;
                }
            });
            futures.add(f);
        }
        this.getAllFutures(futures);
    }
}

