/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.coordinator.remoting;

import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.remoting.AgentRemoteService;
import com.hazelcast.stabilizer.common.AgentAddress;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;

class AgentClient {
    final String publicAddress;
    final String privateIp;

    public AgentClient(AgentAddress address) {
        this.publicAddress = address.publicAddress;
        this.privateIp = address.privateAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object execute(AgentRemoteService.Service service, Object ... args) throws Exception {
        Socket socket = this.newSocket();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            oos.writeObject((Object)service);
            for (Object arg : args) {
                oos.writeObject(arg);
            }
            oos.flush();
            ObjectInputStream in = new ObjectInputStream(socket.getInputStream());
            Object response = in.readObject();
            if (response instanceof Exception) {
                Exception exception = (Exception)response;
                Utils.fixRemoteStackTrace(exception, Thread.currentThread().getStackTrace());
                throw exception;
            }
            Object object = response;
            return object;
        }
        finally {
            Utils.closeQuietly(socket);
        }
    }

    private Socket newSocket() throws IOException {
        try {
            InetAddress hostAddress = InetAddress.getByName(this.publicAddress);
            return new Socket(hostAddress, 9000);
        }
        catch (IOException e) {
            throw new IOException("Couldn't connect to publicAddress: " + this.publicAddress + ":" + 9000, e);
        }
    }
}

