/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.coordinator;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.TestCase;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmSettings;
import com.hazelcast.stabilizer.coordinator.Coordinator;
import com.hazelcast.stabilizer.coordinator.remoting.AgentsClient;
import com.hazelcast.stabilizer.tests.Failure;
import com.hazelcast.stabilizer.tests.TestSuite;
import com.hazelcast.stabilizer.worker.commands.GenericCommand;
import com.hazelcast.stabilizer.worker.commands.InitCommand;
import com.hazelcast.stabilizer.worker.commands.RunCommand;
import com.hazelcast.stabilizer.worker.commands.StopCommand;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Set;

public class TestCaseRunner {
    private static final ILogger log = Logger.getLogger(TestCaseRunner.class);
    private final TestCase testCase;
    private final Coordinator coordinator;
    private final AgentsClient agentsClient;
    private final TestSuite testSuite;
    private final NumberFormat performanceFormat = NumberFormat.getInstance(Locale.US);
    private final String prefix;
    private final Set<Failure.Type> nonCriticalFailures;

    public TestCaseRunner(TestCase testCase, TestSuite testSuite, Coordinator coordinator) {
        this.testCase = testCase;
        this.coordinator = coordinator;
        this.testSuite = testSuite;
        this.agentsClient = coordinator.agentsClient;
        this.prefix = testCase.id.equals("") ? "" : testCase.id + " ";
        this.nonCriticalFailures = testSuite.tolerableFailures;
    }

    public boolean run() throws Exception {
        log.info("--------------------------------------------------------------\n" + String.format("Running Test : %s\n%s", this.testCase.getId(), this.testCase) + "\n" + "--------------------------------------------------------------");
        int oldFailureCount = this.coordinator.failureList.size();
        try {
            this.echo(this.prefix + "Starting Test initialization");
            this.agentsClient.executeOnAllWorkers(new InitCommand(this.testCase));
            this.echo("Completed Test initialization");
            this.echo("Starting Test setup");
            this.agentsClient.executeOnAllWorkers(new GenericCommand(this.testCase.id, "setup"));
            this.agentsClient.waitDone(this.prefix, this.testCase.id);
            this.echo("Completed Test setup");
            this.echo("Starting Test local warmup");
            this.agentsClient.executeOnAllWorkers(new GenericCommand(this.testCase.id, "localWarmup"));
            this.agentsClient.waitDone(this.prefix, this.testCase.id);
            this.echo("Completed Test local warmup");
            this.echo("Starting Test global warmup");
            this.agentsClient.executeOnSingleWorker(new GenericCommand(this.testCase.id, "globalWarmup"));
            this.agentsClient.waitDone(this.prefix, this.testCase.id);
            this.echo("Completed Test global warmup");
            this.echo("Starting Test start");
            this.startTestCase();
            this.echo("Completed Test start");
            this.echo(String.format("Test will run for %s", Utils.secondsToHuman(this.testSuite.duration)));
            this.sleepSeconds(this.testSuite.duration);
            this.echo("Test finished running");
            this.echo("Starting Test stop");
            this.agentsClient.executeOnAllWorkers(new StopCommand(this.testCase.id));
            this.agentsClient.waitDone(this.prefix, this.testCase.id);
            this.echo("Completed Test stop");
            this.logPerformance();
            if (this.coordinator.verifyEnabled) {
                this.echo("Starting Test global verify");
                this.agentsClient.executeOnSingleWorker(new GenericCommand(this.testCase.id, "globalVerify"));
                this.agentsClient.waitDone(this.prefix, this.testCase.id);
                this.echo("Completed Test global verify");
                this.echo("Starting Test local verify");
                this.agentsClient.executeOnAllWorkers(new GenericCommand(this.testCase.id, "localVerify"));
                this.agentsClient.waitDone(this.prefix, this.testCase.id);
                this.echo("Completed Test local verify");
            } else {
                this.echo("Skipping Test verification");
            }
            this.echo("Starting Test global tear down");
            this.agentsClient.executeOnSingleWorker(new GenericCommand(this.testCase.id, "globalTeardown"));
            this.agentsClient.waitDone(this.prefix, this.testCase.id);
            this.echo("Finished Test global tear down");
            this.echo("Starting Test local tear down");
            this.agentsClient.waitDone(this.prefix, this.testCase.id);
            this.agentsClient.executeOnAllWorkers(new GenericCommand(this.testCase.id, "localTeardown"));
            this.echo("Completed Test local tear down");
            return this.coordinator.failureList.size() == oldFailureCount;
        }
        catch (Exception e) {
            log.severe("Failed", (Throwable)e);
            return false;
        }
    }

    private void logPerformance() {
        if (this.coordinator.monitorPerformance) {
            log.info("Operation-count: " + this.performanceFormat.format(this.coordinator.operationCount));
            double performance = (double)this.coordinator.operationCount * 1.0 / (double)this.testSuite.duration;
            log.info("Performance: " + this.performanceFormat.format(performance) + " ops/s");
        }
    }

    private void startTestCase() {
        WorkerJvmSettings workerJvmSettings = this.coordinator.workerJvmSettings;
        RunCommand runCommand = new RunCommand(this.testCase.id);
        runCommand.clientOnly = workerJvmSettings.mixedWorkerCount > 0 || workerJvmSettings.clientWorkerCount > 0;
        this.agentsClient.executeOnAllWorkers(runCommand);
    }

    public void sleepSeconds(int seconds) {
        int period = 30;
        int big = seconds / period;
        int small = seconds % period;
        for (int k = 1; k <= big; ++k) {
            if (this.shouldTerminate()) {
                this.echo("Critical Failure detected, aborting execution of test");
                return;
            }
            Utils.sleepSeconds(period);
            int elapsed = period * k;
            float percentage = 100.0f * (float)elapsed / (float)seconds;
            String msg = String.format("Running %s, %-4.2f percent complete", Utils.secondsToHuman(elapsed), Float.valueOf(percentage));
            if (this.coordinator.monitorPerformance) {
                msg = msg + ", " + this.performanceFormat.format(this.coordinator.performance) + " ops/s.";
            }
            log.info(this.prefix + msg);
        }
        Utils.sleepSeconds(small);
    }

    private boolean shouldTerminate() {
        for (Failure failure : this.coordinator.failureList) {
            if (this.nonCriticalFailures.contains((Object)failure.type)) continue;
            return true;
        }
        return false;
    }

    private void echo(String msg) {
        this.agentsClient.echo(this.prefix + msg);
        log.info(this.prefix + msg);
    }
}

