/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.coordinator;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.coordinator.Coordinator;
import com.hazelcast.stabilizer.coordinator.remoting.AgentsClient;
import com.hazelcast.stabilizer.worker.commands.GetOperationCountCommand;
import java.util.List;

public class PerformanceMonitor
extends Thread {
    private final ILogger log = Logger.getLogger(PerformanceMonitor.class);
    private final AgentsClient client;
    private final Coordinator coordinator;
    private long previousCount = 0L;
    public long previousTime = System.currentTimeMillis();

    public PerformanceMonitor(Coordinator coordinator) {
        this.client = coordinator.agentsClient;
        this.coordinator = coordinator;
    }

    @Override
    public void run() {
        while (true) {
            Utils.sleepSeconds(10);
            try {
                this.checkPerformance();
                continue;
            }
            catch (Throwable t) {
                this.log.severe(t);
                continue;
            }
            break;
        }
    }

    private void checkPerformance() {
        GetOperationCountCommand getOperationCountTestCommand = new GetOperationCountCommand();
        List result = this.client.executeOnAllWorkers(getOperationCountTestCommand);
        long currentCount = 0L;
        for (List list : result) {
            for (Long item : list) {
                if (item == null) continue;
                currentCount += item.longValue();
            }
        }
        long delta = currentCount - this.previousCount;
        long currentMs = System.currentTimeMillis();
        long durationMs = currentMs - this.previousTime;
        this.coordinator.performance = (double)delta * 1000.0 / (double)durationMs;
        this.coordinator.operationCount = currentCount;
        this.previousTime = currentMs;
        this.previousCount = currentCount;
    }
}

