/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.coordinator;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.coordinator.Coordinator;
import com.hazelcast.stabilizer.tests.Failure;
import java.io.File;
import java.util.List;

class FailureMonitorThread
extends Thread {
    private final Coordinator coordinator;
    private final ILogger log = Logger.getLogger(FailureMonitorThread.class);
    private final File file;

    public FailureMonitorThread(Coordinator coordinator) {
        super("FailureMonitorThread");
        this.file = new File("failures-" + coordinator.testSuite.id + ".txt");
        if (coordinator == null) {
            throw new NullPointerException();
        }
        this.coordinator = coordinator;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Utils.sleepSeconds(1);
                    this.scan();
                }
            }
            catch (Throwable e) {
                this.log.severe(e);
                continue;
            }
            break;
        }
    }

    private void scan() {
        List<Failure> failures = this.coordinator.agentsClient.getFailures();
        for (Failure failure : failures) {
            this.coordinator.failureList.add(failure);
            this.log.warning(this.buildMessage(failure));
            Utils.appendText(failure.toString() + "\n", this.file);
        }
    }

    private String buildMessage(Failure failure) {
        String[] lines;
        StringBuilder sb = new StringBuilder();
        sb.append("Failure #").append(this.coordinator.failureList.size()).append(" ");
        if (failure.workerAddress != null) {
            sb.append(' ');
            sb.append(failure.workerAddress);
            sb.append(' ');
        } else if (failure.agentAddress != null) {
            sb.append(' ');
            sb.append(failure.agentAddress);
            sb.append(' ');
        }
        sb.append((Object)failure.type);
        if (failure.cause != null && (lines = failure.cause.split("\n")).length > 0) {
            sb.append("[");
            sb.append(lines[0]);
            sb.append("]");
        }
        return sb.toString();
    }
}

