/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.coordinator;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmSettings;
import com.hazelcast.stabilizer.coordinator.Coordinator;
import com.hazelcast.stabilizer.tests.Failure;
import com.hazelcast.stabilizer.tests.TestSuite;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class CoordinatorCli {
    private static final ILogger log = Logger.getLogger(CoordinatorCli.class);
    private final OptionParser parser = new OptionParser();
    private final OptionSpec<String> durationSpec = this.parser.accepts("duration", "Amount of time to run per test. Can be e.g. 10 or 10s, 1m or 2h or 3d.").withRequiredArg().ofType(String.class).defaultsTo((Object)"60", (Object[])new String[0]);
    private final OptionSpec<Integer> memberWorkerCountSpec = this.parser.accepts("memberWorkerCount", "Number of Cluster member Worker JVM's. If no value is specified and no mixed members are specified, then the number of cluster members will be equal to the number of machines in the agents file").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
    private final OptionSpec<Integer> clientWorkerCountSpec = this.parser.accepts("clientWorkerCount", "Number of Cluster Client Worker JVM's").withRequiredArg().ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
    private final OptionSpec<Integer> mixedWorkerCountSpec = this.parser.accepts("mixedWorkerCount", "Number of Mixed Cluster member JVM's (a client hz + member hz and all communication through client)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
    private final OptionSpec<String> workerClassPathSpec = this.parser.accepts("workerClassPath", "A file/directory containing the classes/jars/resources that are going to be uploaded to the agents. Use ';' as separator for multiple entries. Wildcard '*' can also be used.").withRequiredArg().ofType(String.class);
    private final OptionSpec monitorPerformanceSpec = this.parser.accepts("monitorPerformance", "Track performance");
    private final OptionSpec<Boolean> verifyEnabledSpec = this.parser.accepts("verifyEnabled", "If test should be verified").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
    private final OptionSpec<Boolean> workerRefreshSpec = this.parser.accepts("workerFresh", "If the worker JVM's should be replaced after every testsuite").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
    private final OptionSpec<Boolean> failFastSpec = this.parser.accepts("failFast", "It the testsuite should fail immediately when a Test from a testsuite fails instead of continuing ").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
    private final OptionSpec<String> tolerableFailureSpec = this.parser.accepts("tolerableFailure", String.format("It the test should not fail when given failure is detected. List of known failures: '%s'", Failure.Type.getIdsAsString())).withRequiredArg().ofType(String.class);
    private final OptionSpec parallelSpec = this.parser.accepts("parallel", "It tests should be run in parallel.");
    private final OptionSpec<String> workerVmOptionsSpec = this.parser.accepts("workerVmOptions", "Worker VM options (quotes can be used)").withRequiredArg().ofType(String.class).defaultsTo((Object)"-XX:+HeapDumpOnOutOfMemoryError", (Object[])new String[0]);
    private final OptionSpec<String> agentsFileSpec = this.parser.accepts("agentsFile", "The file containing the list of agent machines").withRequiredArg().ofType(String.class).defaultsTo((Object)"agents.txt", (Object[])new String[0]);
    private final OptionSpec<String> propertiesFileSpec = this.parser.accepts("propertiesFile", "The file containing the stabilizer properties. If no file is explicitly configured, first the working directory is checked for a file 'stabilizer.properties'. All missing propertiesare always loaded from STABILIZER_HOME/conf/stabilizer.properties").withRequiredArg().ofType(String.class);
    private final OptionSpec<String> hzFileSpec = this.parser.accepts("hzFile", "The Hazelcast xml configuration file for the worker. If one is not explicitly configured, firstthe 'hazelcast.xml' in the working directory is loaded, if that doesn't exist then STABILIZER_HOME/conf/hazelcast.xml is loaded.").withRequiredArg().ofType(String.class).defaultsTo((Object)CoordinatorCli.getDefaultHzFile(), (Object[])new String[0]);
    private final OptionSpec<String> clientHzFileSpec = this.parser.accepts("clientHzFile", "The client Hazelcast xml configuration file for the worker. If one is not explicitly configured, firstthe 'client-hazelcast.xml' in the working directory is loaded, if that doesn't exist then STABILIZER_HOME/conf/client-hazelcast.xml is loaded.").withRequiredArg().ofType(String.class).defaultsTo((Object)CoordinatorCli.getDefaultClientHzFile(), (Object[])new String[0]);
    private final OptionSpec<Integer> workerStartupTimeoutSpec = this.parser.accepts("workerStartupTimeout", "The startup timeout in seconds for a worker").withRequiredArg().ofType(Integer.class).defaultsTo((Object)60, (Object[])new Integer[0]);
    private final OptionSpec<Integer> testStopTimeoutMsSpec = this.parser.accepts("testStopTimeoutMs", "Maximum amount of time waiting for the Test to stop").withRequiredArg().ofType(Integer.class).defaultsTo((Object)60000, (Object[])new Integer[0]);
    private final OptionSpec helpSpec = this.parser.accepts("help", "Show help").forHelp();
    private final Coordinator coordinator;
    private OptionSet options;

    private static String getDefaultHzFile() {
        File file = new File("hazelcast.xml");
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return Coordinator.STABILIZER_HOME + File.separator + "conf" + File.separator + "hazelcast.xml";
    }

    private static String getDefaultClientHzFile() {
        File file = new File("client-hazelcast.xml");
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return Coordinator.STABILIZER_HOME + File.separator + "conf" + File.separator + "client-hazelcast.xml";
    }

    public CoordinatorCli(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void init(String[] args) throws Exception {
        TestSuite testSuite;
        try {
            this.options = this.parser.parse(args);
        }
        catch (OptionException e) {
            Utils.exitWithError(log, e.getMessage() + ". Use --help to get overview of the help options.");
            return;
        }
        if (this.options.has(this.helpSpec)) {
            this.parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        if (this.options.has(this.workerClassPathSpec)) {
            this.coordinator.workerClassPath = (String)this.options.valueOf(this.workerClassPathSpec);
        }
        this.coordinator.props.init(this.getPropertiesFile());
        this.coordinator.verifyEnabled = (Boolean)this.options.valueOf(this.verifyEnabledSpec);
        this.coordinator.monitorPerformance = this.options.has(this.monitorPerformanceSpec);
        this.coordinator.testStopTimeoutMs = (Integer)this.options.valueOf(this.testStopTimeoutMsSpec);
        this.coordinator.agentsFile = Utils.getFile(this.agentsFileSpec, this.options, "Agents file");
        this.coordinator.parallel = this.options.has(this.parallelSpec);
        this.coordinator.testSuite = testSuite = TestSuite.loadTestSuite(this.getTestSuiteFile());
        testSuite.duration = this.getDuration();
        testSuite.failFast = (Boolean)this.options.valueOf(this.failFastSpec);
        testSuite.tolerableFailures = Failure.Type.fromPropertyValue((String)this.options.valueOf(this.tolerableFailureSpec));
        WorkerJvmSettings workerJvmSettings = new WorkerJvmSettings();
        workerJvmSettings.vmOptions = (String)this.options.valueOf(this.workerVmOptionsSpec);
        workerJvmSettings.memberWorkerCount = (Integer)this.options.valueOf(this.memberWorkerCountSpec);
        workerJvmSettings.clientWorkerCount = (Integer)this.options.valueOf(this.clientWorkerCountSpec);
        workerJvmSettings.mixedWorkerCount = (Integer)this.options.valueOf(this.mixedWorkerCountSpec);
        workerJvmSettings.workerStartupTimeout = (Integer)this.options.valueOf(this.workerStartupTimeoutSpec);
        workerJvmSettings.hzConfig = this.loadHzConfig();
        workerJvmSettings.clientHzConfig = this.loadClientHzConfig();
        workerJvmSettings.refreshJvm = (Boolean)this.options.valueOf(this.workerRefreshSpec);
        workerJvmSettings.profiler = this.coordinator.props.get("PROFILER", "none");
        workerJvmSettings.yourkitConfig = this.coordinator.props.get("YOURKIT_SETTINGS");
        workerJvmSettings.hprofSettings = this.coordinator.props.get("HPROF_SETTINGS", "");
        this.coordinator.workerJvmSettings = workerJvmSettings;
    }

    private String loadClientHzConfig() {
        File file = Utils.getFile(this.clientHzFileSpec, this.options, "Worker Client Hazelcast config file");
        log.info("Loading Hazelcast client configuration: " + file.getAbsolutePath());
        return Utils.fileAsText(file);
    }

    private String loadHzConfig() {
        File file = Utils.getFile(this.hzFileSpec, this.options, "Worker Hazelcast config file");
        log.info("Loading Hazelcast configuration: " + file.getAbsolutePath());
        return Utils.fileAsText(file);
    }

    private File getPropertiesFile() {
        if (this.options.has(this.propertiesFileSpec)) {
            return Utils.newFile((String)this.options.valueOf(this.propertiesFileSpec));
        }
        return null;
    }

    private File getTestSuiteFile() {
        String testsuiteFileName = null;
        List testsuiteFiles = this.options.nonOptionArguments();
        if (testsuiteFiles.isEmpty()) {
            testsuiteFileName = new File("test.properties").getAbsolutePath();
        } else if (testsuiteFiles.size() == 1) {
            testsuiteFileName = (String)testsuiteFiles.get(0);
        } else if (testsuiteFiles.size() > 1) {
            Utils.exitWithError(log, "Too many testsuite files specified.");
            return null;
        }
        File testSuiteFile = new File(testsuiteFileName);
        log.info("Loading testsuite file: " + testSuiteFile.getAbsolutePath());
        if (!testSuiteFile.exists()) {
            Utils.exitWithError(log, String.format("Can't find testsuite file [%s]", testSuiteFile));
        }
        return testSuiteFile;
    }

    private int getDuration() {
        String value = (String)this.options.valueOf(this.durationSpec);
        try {
            if (value.endsWith("s")) {
                String sub = value.substring(0, value.length() - 1);
                return Integer.parseInt(sub);
            }
            if (value.endsWith("m")) {
                String sub = value.substring(0, value.length() - 1);
                return (int)TimeUnit.MINUTES.toSeconds(Integer.parseInt(sub));
            }
            if (value.endsWith("h")) {
                String sub = value.substring(0, value.length() - 1);
                return (int)TimeUnit.HOURS.toSeconds(Integer.parseInt(sub));
            }
            if (value.endsWith("d")) {
                String sub = value.substring(0, value.length() - 1);
                return (int)TimeUnit.DAYS.toSeconds(Integer.parseInt(sub));
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Utils.exitWithError(log, String.format("Failed to parse duration [%s], cause: %s", value, e.getMessage()));
            return -1;
        }
    }
}

