/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.coordinator;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.TestCase;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.SpawnWorkerFailedException;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmSettings;
import com.hazelcast.stabilizer.common.AgentAddress;
import com.hazelcast.stabilizer.common.AgentsFile;
import com.hazelcast.stabilizer.common.GitInfo;
import com.hazelcast.stabilizer.common.StabilizerProperties;
import com.hazelcast.stabilizer.coordinator.CoordinatorCli;
import com.hazelcast.stabilizer.coordinator.FailureMonitorThread;
import com.hazelcast.stabilizer.coordinator.PerformanceMonitor;
import com.hazelcast.stabilizer.coordinator.TestCaseRunner;
import com.hazelcast.stabilizer.coordinator.remoting.AgentsClient;
import com.hazelcast.stabilizer.provisioner.Bash;
import com.hazelcast.stabilizer.tests.Failure;
import com.hazelcast.stabilizer.tests.TestSuite;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class Coordinator {
    public static final File STABILIZER_HOME = Utils.getStablizerHome();
    private static final ILogger log = Logger.getLogger(Coordinator.class);
    public boolean monitorPerformance;
    public boolean verifyEnabled = true;
    public String workerClassPath;
    public Integer testStopTimeoutMs;
    public File agentsFile;
    public TestSuite testSuite;
    final BlockingQueue<Failure> failureList = new LinkedBlockingQueue<Failure>();
    protected AgentsClient agentsClient;
    public WorkerJvmSettings workerJvmSettings;
    public StabilizerProperties props = new StabilizerProperties();
    public volatile double performance;
    public volatile long operationCount;
    private Bash bash;
    public boolean parallel;

    private void run() throws Exception {
        this.bash = new Bash(this.props);
        this.initAgents();
        this.startWorkers();
        new FailureMonitorThread(this).start();
        if (this.monitorPerformance) {
            new PerformanceMonitor(this).start();
        }
        this.runTestSuite();
        this.logFailureInfo();
    }

    private void logFailureInfo() {
        if (this.failureList.isEmpty()) {
            log.info("-----------------------------------------------------------------------------");
            log.info("No failures have been detected!");
            log.info("-----------------------------------------------------------------------------");
            System.exit(0);
        } else {
            log.info("-----------------------------------------------------------------------------");
            log.info(this.failureList.size() + " failures have been detected!!!!");
            log.info("-----------------------------------------------------------------------------");
            System.exit(1);
        }
    }

    private void initAgents() throws Exception {
        List<AgentAddress> agentAddresses = AgentsFile.load(this.agentsFile);
        this.agentsClient = new AgentsClient(agentAddresses);
        this.agentsClient.start();
        this.initMemberWorkerCount(this.workerJvmSettings);
        this.initHzConfig(this.workerJvmSettings);
        this.initClientHzConfig(this.workerJvmSettings);
        int agentCount = this.agentsClient.getAgentCount();
        log.info(String.format("Performance monitor enabled: %s", this.monitorPerformance));
        log.info(String.format("Total number of agents: %s", agentCount));
        log.info(String.format("Total number of Hazelcast member workers: %s", this.workerJvmSettings.memberWorkerCount));
        log.info(String.format("Total number of Hazelcast client workers: %s", this.workerJvmSettings.clientWorkerCount));
        log.info(String.format("Total number of Hazelcast mixed client & member workers: %s", this.workerJvmSettings.mixedWorkerCount));
        this.agentsClient.initTestSuite(this.testSuite);
        this.uploadWorkerClassPath();
        this.uploadYourKitIfNeeded();
    }

    private List<File> createUpload() throws IOException {
        return Utils.getFilesFromClassPath(this.workerClassPath);
    }

    private void initHzConfig(WorkerJvmSettings settings) throws Exception {
        int port = this.getPort(settings);
        StringBuffer members = new StringBuffer();
        for (String hostAddress : this.agentsClient.getPrivateAddresses()) {
            members.append("<member>").append(hostAddress).append(":").append(port).append("</member>\n");
        }
        settings.hzConfig = settings.hzConfig.replace("<!--MEMBERS-->", members);
    }

    private void initClientHzConfig(WorkerJvmSettings settings) throws Exception {
        int port = this.getPort(settings);
        StringBuffer members = new StringBuffer();
        for (String hostAddress : this.agentsClient.getPrivateAddresses()) {
            members.append("<address>").append(hostAddress).append(":").append(port).append("</address>\n");
        }
        settings.clientHzConfig = settings.clientHzConfig.replace("<!--MEMBERS-->", members);
    }

    private int getPort(WorkerJvmSettings settings) throws UnsupportedEncodingException {
        Config config = new XmlConfigBuilder((InputStream)new ByteArrayInputStream(settings.hzConfig.getBytes("UTF-8"))).build();
        return config.getNetworkConfig().getPort();
    }

    private void runTestSuite() throws Exception {
        this.echo(String.format("Starting testsuite: %s", this.testSuite.id));
        this.echo(String.format("Tests in testsuite: %s", this.testSuite.size()));
        this.echo(String.format("Running time per test: %s ", Utils.secondsToHuman(this.testSuite.duration)));
        this.echo(String.format("Expected total testsuite time: %s", Utils.secondsToHuman(this.testSuite.size() * this.testSuite.duration)));
        long startMs = System.currentTimeMillis();
        if (this.parallel) {
            this.runParallel();
        } else {
            this.runSequential();
        }
        this.terminateWorkers();
        log.info("Starting cool down (10 sec)");
        Utils.sleepSeconds(10);
        log.info("Finished cool down");
        long elapsedMs = System.currentTimeMillis() - startMs;
        log.info(String.format("Total running time: %s seconds", elapsedMs / 1000L));
    }

    private void runSequential() throws Exception {
        this.echo(String.format("Running %s tests sequentially", this.testSuite.size()));
        for (TestCase testCase : this.testSuite.testCaseList) {
            TestCaseRunner runner = new TestCaseRunner(testCase, this.testSuite, this);
            boolean success = runner.run();
            if (!success && this.testSuite.failFast) {
                log.info("Aborting testsuite due to failure");
                break;
            }
            if (success && !this.workerJvmSettings.refreshJvm) continue;
            this.terminateWorkers();
            this.startWorkers();
        }
    }

    private void runParallel() throws InterruptedException, ExecutionException {
        this.echo(String.format("Running %s tests parallel", this.testSuite.size()));
        ExecutorService executor = Executors.newFixedThreadPool(this.testSuite.size());
        LinkedList futures = new LinkedList();
        for (final TestCase testCase : this.testSuite.testCaseList) {
            Future<?> f = executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        TestCaseRunner runner = new TestCaseRunner(testCase, Coordinator.this.testSuite, Coordinator.this);
                        boolean success = runner.run();
                        if (!success && Coordinator.this.testSuite.failFast) {
                            log.info("Aborting testsuite due to failure");
                            return;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            futures.add(f);
        }
        for (Future future : futures) {
            future.get();
        }
    }

    void terminateWorkers() throws Exception {
        this.echo("Terminating workers");
        this.agentsClient.terminateWorkers();
        this.echo("All workers have been terminated");
    }

    long startWorkers() throws Exception {
        WorkerJvmSettings s;
        int k;
        this.echo("Starting workers");
        long startMs = System.currentTimeMillis();
        int agentCount = this.agentsClient.getAgentCount();
        WorkerJvmSettings[] settingsArray = new WorkerJvmSettings[agentCount];
        for (int k2 = 0; k2 < agentCount; ++k2) {
            WorkerJvmSettings s2 = new WorkerJvmSettings(this.workerJvmSettings);
            s2.memberWorkerCount = 0;
            s2.mixedWorkerCount = 0;
            s2.clientWorkerCount = 0;
            settingsArray[k2] = s2;
        }
        int index = 0;
        for (k = 0; k < this.workerJvmSettings.memberWorkerCount; ++k) {
            s = settingsArray[index % agentCount];
            ++s.memberWorkerCount;
            ++index;
        }
        for (k = 0; k < this.workerJvmSettings.clientWorkerCount; ++k) {
            s = settingsArray[index % agentCount];
            ++s.clientWorkerCount;
            ++index;
        }
        for (k = 0; k < this.workerJvmSettings.mixedWorkerCount; ++k) {
            s = settingsArray[index % agentCount];
            ++s.mixedWorkerCount;
            ++index;
        }
        try {
            this.agentsClient.spawnWorkers(settingsArray);
        }
        catch (SpawnWorkerFailedException e) {
            log.severe(e.getMessage());
            System.exit(1);
        }
        long durationMs = System.currentTimeMillis() - startMs;
        log.info(String.format("Finished starting a grand total of %s Workers JVM's after %s ms", this.workerJvmSettings.totalWorkerCount(), durationMs));
        return startMs;
    }

    private void initMemberWorkerCount(WorkerJvmSettings masterSettings) {
        int agentCount = this.agentsClient.getAgentCount();
        if (masterSettings.memberWorkerCount == -1 && masterSettings.mixedWorkerCount == 0) {
            masterSettings.memberWorkerCount = agentCount;
        }
    }

    private void echo(String msg) {
        this.agentsClient.echo(msg);
        log.info(msg);
    }

    private void uploadWorkerClassPath() throws IOException {
        if (this.workerClassPath != null) {
            log.info(String.format("Copying workerClasspath '%s' to agents", this.workerClassPath));
            List<File> upload = this.createUpload();
            for (String ip : this.agentsClient.getPublicAddresses()) {
                for (File file : upload) {
                    String syncCommand = String.format("rsync --ignore-existing -av -e \"ssh %s\" %s %s@%s:hazelcast-stabilizer-%s/workers/%s/lib", this.props.get("SSH_OPTIONS", ""), file.getAbsolutePath(), this.props.get("USER"), ip, Utils.getVersion(), this.testSuite.id);
                    this.bash.execute(syncCommand);
                }
            }
            log.info(String.format("Finished copying workerClasspath '%s' to agents", this.workerClassPath));
        }
    }

    private void uploadYourKitIfNeeded() {
        if ("yourkit".equals(this.workerJvmSettings.profiler)) {
            log.info("Ensuring Yourkit dependencies available on remote machines");
            for (String ip : this.agentsClient.getPublicAddresses()) {
                this.bash.ssh(ip, String.format("mkdir -p hazelcast-stabilizer-%s/yourkit", Utils.getVersion()));
                String syncCommand = String.format("rsync --ignore-existing -av -e \"ssh %s\" %s/yourkit %s@%s:hazelcast-stabilizer-%s/", this.props.get("SSH_OPTIONS", ""), Utils.getStablizerHome().getAbsolutePath(), this.props.get("USER"), ip, Utils.getVersion());
                this.bash.execute(syncCommand);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        log.info("Hazelcast Stabilizer Coordinator");
        log.info(String.format("Version: %s, Commit: %s, Build Time: %s", Utils.getVersion(), GitInfo.getCommitIdAbbrev(), GitInfo.getBuildTime()));
        log.info(String.format("STABILIZER_HOME: %s", STABILIZER_HOME));
        Coordinator coordinator = new Coordinator();
        CoordinatorCli cli = new CoordinatorCli(coordinator);
        cli.init(args);
        log.info(String.format("Loading agents file: %s", coordinator.agentsFile.getAbsolutePath()));
        try {
            coordinator.run();
            System.exit(0);
        }
        catch (Exception e) {
            log.severe("Failed to run testsuite", (Throwable)e);
            System.exit(1);
        }
    }
}

