/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.communicator;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.common.messaging.Message;
import com.hazelcast.stabilizer.common.messaging.MessageAddress;
import com.hazelcast.stabilizer.common.messaging.MessageAddressParser;
import com.hazelcast.stabilizer.communicator.Communicator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class CommunicatorCli {
    private static final ILogger log = Logger.getLogger(CommunicatorCli.class);
    private final Communicator communicator;
    private final OptionParser parser = new OptionParser();
    private OptionSet options;
    private final OptionSpec<String> agentsFileSpec = this.parser.accepts("agentsFile", "The file containing the list of agent machines").withRequiredArg().ofType(String.class).defaultsTo((Object)"agents.txt", (Object[])new String[0]);
    private final OptionSpec<String> messageTypeSpec = this.parser.accepts("message-type", String.format("Message type definition. Supported message types: %n%s", Message.getMessageHelp())).withRequiredArg().ofType(String.class);
    private final OptionSpec<String> messageAddressSpec = this.parser.accepts("message-address", String.format("Message address definition. %nSyntax: Agent=<mode>[,Worker=<mode>[,Test=<mode>]]. Mode can be either '%s' for broadcast' or '%s' for a single random destination. %nExamples: %n--message-address 'Agent=*,Worker=R' - a message will be routed to all agents and than each agent will pass it to a single random worker for processing. %n          %n--message-address 'Agent=R,Worker=R,Test=*' - a message will be router to a single random agent. The agent will pass it to a single random worker and the worker will pass the message to all tests.", "*", "R")).withRequiredArg().ofType(String.class);
    private final OptionSpec oldestMemberSpec = this.parser.accepts("oldest-member", "Send the message to a worker with the oldest cluster member.");
    private final OptionSpec randomAgentSpec = this.parser.accepts("random-agent", "Send the message to a random agent. Cannot be used together with --message-address or any other addressing option.");
    private final OptionSpec randomWorkerSpec = this.parser.accepts("random-worker", "Send the message to a worker agent. Cannot be used together with --message-address or any other addressing option.");
    private final OptionSpec helpSpec = this.parser.accepts("help", "Show help").forHelp();

    public CommunicatorCli(Communicator communicator) {
        this.communicator = communicator;
    }

    public void init(String[] args) throws IOException {
        try {
            this.options = this.parser.parse(args);
        }
        catch (OptionException e) {
            Utils.exitWithError(log, e.getMessage() + ". Use --help to get overview of the help options.");
            return;
        }
        if (this.options.has(this.helpSpec)) {
            this.parser.formatHelpWith((HelpFormatter)new BuiltinHelpFormatter(160, 2));
            this.parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        String messageTypeString = null;
        List noArgOptions = this.options.nonOptionArguments();
        if (this.options.has(this.messageTypeSpec)) {
            if (!noArgOptions.isEmpty()) {
                Utils.exitWithError(log, "You cannot use --message-type simultaneously with a message shortcut. Use --help to get overview of the help options.");
            }
            messageTypeString = (String)this.options.valueOf(this.messageTypeSpec);
        } else if (!noArgOptions.isEmpty()) {
            if (noArgOptions.size() > 1) {
                Utils.exitWithError(log, "You cannot use more than 1 message shortcut.");
            }
            messageTypeString = (String)noArgOptions.get(0);
        } else {
            Utils.exitWithError(log, "You have to use either --message-type or message shortcut Use --help to get overview of the help options.");
        }
        MessageAddress messageAddress = null;
        if (this.options.has(this.randomAgentSpec)) {
            this.checkHasOnlyAddressingOption(this.randomAgentSpec);
            messageAddress = MessageAddress.builder().toRandomAgent().build();
        } else if (this.options.has(this.oldestMemberSpec)) {
            this.checkHasOnlyAddressingOption(this.oldestMemberSpec);
            messageAddress = MessageAddress.builder().toOldestMember().build();
        } else if (this.options.has(this.messageAddressSpec)) {
            this.checkHasOnlyAddressingOption(this.messageAddressSpec);
            MessageAddressParser addressParser = new MessageAddressParser();
            String messageAddressString = (String)this.options.valueOf(this.messageAddressSpec);
            messageAddress = addressParser.parse(messageAddressString);
        } else if (this.options.has(this.randomWorkerSpec)) {
            this.checkHasOnlyAddressingOption(this.randomWorkerSpec);
            messageAddress = MessageAddress.builder().toAllAgents().toRandomWorker().build();
        } else {
            Utils.exitWithError(log, "You have to use either --oldest-member or --message-address to specify message address. Use --help to get overview of the help options.");
        }
        this.communicator.message = Message.newBySpec(messageTypeString, messageAddress);
        this.communicator.agentsFile = Utils.getFile(this.agentsFileSpec, this.options, "Agents file");
    }

    private void checkHasOnlyAddressingOption(OptionSpec optionSpec) {
        if (this.hasOtherAddressOptionThen(optionSpec)) {
            Utils.exitWithError(log, "You cannot use --random-agent and --message-address or any other addressing option simultaneously. Use --help to get overview of the help options.");
        }
    }

    private boolean hasOtherAddressOptionThen(OptionSpec optionSpec) {
        OptionSpec[] addressOptionSpecs;
        for (OptionSpec o : addressOptionSpecs = new OptionSpec[]{this.messageAddressSpec, this.randomAgentSpec, this.oldestMemberSpec, this.randomWorkerSpec}) {
            if (o.equals(optionSpec) || !this.options.has(o)) continue;
            return true;
        }
        return false;
    }
}

