/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.communicator;

import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.common.AgentAddress;
import com.hazelcast.stabilizer.common.AgentsFile;
import com.hazelcast.stabilizer.common.messaging.Message;
import com.hazelcast.stabilizer.communicator.CommunicatorCli;
import com.hazelcast.stabilizer.coordinator.remoting.AgentsClient;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class Communicator {
    private static final Logger log = Logger.getLogger((String)Communicator.class.getName());
    private static final String STABILIZER_HOME = Utils.getStablizerHome().getAbsolutePath();
    public File agentsFile;
    protected AgentsClient agentsClient;
    public Message message;

    public static void main(String[] args) throws IOException {
        log.info((Object)"Stabilizer Communicator");
        log.info((Object)String.format("Version: %s", Utils.getVersion()));
        log.info((Object)String.format("STABILIZER_HOME: %s", STABILIZER_HOME));
        Communicator communicator = new Communicator();
        CommunicatorCli cli = new CommunicatorCli(communicator);
        cli.init(args);
        log.info((Object)String.format("Loading agents file: %s", communicator.agentsFile.getAbsolutePath()));
        try {
            communicator.run();
            System.exit(0);
        }
        catch (Exception e) {
            log.error((Object)"Failed to communicate", (Throwable)e);
            System.exit(1);
        }
    }

    private void run() throws Exception {
        this.initAgents();
        this.agentsClient.sendMessage(this.message);
    }

    private void initAgents() throws Exception {
        List<AgentAddress> agentAddresses = AgentsFile.load(this.agentsFile);
        this.agentsClient = new AgentsClient(agentAddresses);
        this.agentsClient.start();
    }
}

