/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.common.messaging;

import com.hazelcast.stabilizer.common.KeyValuePair;
import com.hazelcast.stabilizer.common.messaging.Message;
import com.hazelcast.stabilizer.common.messaging.MessageAddress;
import com.hazelcast.stabilizer.common.messaging.MessageAddressParser;
import com.hazelcast.stabilizer.common.messaging.MessageSpec;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

class MessagesFactory {
    private static final Logger log = Logger.getLogger(MessagesFactory.class);
    private static final MessagesFactory instance = new MessagesFactory();
    private final Map<String, Constructor<? extends Message>> noAttributeConstructors = new HashMap<String, Constructor<? extends Message>>();
    private final Map<String, Constructor<? extends Message>> attributeConstructors = new HashMap<String, Constructor<? extends Message>>();
    private final Map<String, String> messageDesription;
    private final MessageAddressParser messageAddressParser = new MessageAddressParser();

    private MessagesFactory() {
        this.messageDesription = new HashMap<String, String>();
        this.findAndInitMessageTypes();
    }

    static Set<String> getMessageSpecs() {
        HashSet<String> constructors = new HashSet<String>(MessagesFactory.instance.noAttributeConstructors.keySet());
        constructors.addAll(MessagesFactory.instance.attributeConstructors.keySet());
        return constructors;
    }

    static String getMessageDescription(String messageSpec) {
        String description = MessagesFactory.instance.messageDesription.get(messageSpec);
        if (description == null) {
            throw new IllegalArgumentException("Unknown message type '" + messageSpec + "'.");
        }
        return description;
    }

    static Message bySpec(String messageTypeSpec, String messageAddressSpec) {
        MessageAddress address = MessagesFactory.instance.messageAddressParser.parse(messageAddressSpec);
        return MessagesFactory.bySpec(messageTypeSpec, address);
    }

    static Message bySpec(String messageTypeSpec, MessageAddress messageAddress) {
        Constructor<? extends Message> constructor = MessagesFactory.instance.noAttributeConstructors.get(messageTypeSpec);
        if (constructor == null) {
            throw new IllegalArgumentException("Unknown message type " + messageTypeSpec + ".");
        }
        return MessagesFactory.createInstance(constructor, messageAddress, null);
    }

    static Message bySpec(String messageTypeSpec, String messageAddressSpec, KeyValuePair<? extends Serializable, ? extends Serializable> attribute) {
        MessageAddress address = MessagesFactory.instance.messageAddressParser.parse(messageAddressSpec);
        return MessagesFactory.bySpec(messageTypeSpec, address, attribute);
    }

    static Message bySpec(String messageTypeSpec, MessageAddress messageAddress, KeyValuePair<? extends Serializable, ? extends Serializable> attribute) {
        Constructor<? extends Message> constructor = MessagesFactory.instance.attributeConstructors.get(messageTypeSpec);
        if (constructor == null) {
            throw new IllegalArgumentException("Unknown message type " + messageTypeSpec + ".");
        }
        return MessagesFactory.createInstance(constructor, messageAddress, attribute);
    }

    private static Message createInstance(Constructor<? extends Message> constructor, MessageAddress messageAddress, KeyValuePair<? extends Serializable, ? extends Serializable> attribute) {
        try {
            return attribute == null ? constructor.newInstance(messageAddress) : constructor.newInstance(messageAddress, attribute);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Error while creating a new message", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Error while creating a new message", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Error while creating a new message", e);
        }
    }

    private void findAndInitMessageTypes() {
        Reflections reflections = new Reflections("", new Scanner[0]);
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(MessageSpec.class);
        for (Class clazz : typesAnnotatedWith) {
            if (Message.class.isAssignableFrom(clazz)) {
                this.registerMessage(clazz);
                continue;
            }
            log.warn((Object)("Class " + clazz.getName() + " is annotated with " + MessageSpec.class.getName() + ", however it does" + "not extend " + Message.class.getName() + "."));
        }
    }

    private void registerMessage(Class<? extends Message> clazz) {
        boolean registered = this.registerMessageTryBasicConstructor(clazz);
        if (this.registerMessageTryConstructorWithKeyValue(clazz).booleanValue() || registered) {
            this.registerDescription(clazz);
        }
    }

    private void registerDescription(Class<? extends Message> clazz) {
        String specString = this.getSpecString(clazz);
        String description = this.getDescription(clazz);
        this.messageDesription.put(specString, description);
    }

    private Boolean registerMessageTryConstructorWithKeyValue(Class<? extends Message> clazz) {
        String spec = this.getSpecString(clazz);
        try {
            Constructor<? extends Message> constructor = clazz.getConstructor(MessageAddress.class, KeyValuePair.class);
            this.attributeConstructors.put(spec, constructor);
            return true;
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)("Class " + clazz.getName() + " does not have a constructor accepting " + KeyValuePair.class.getName() + "+."));
            return false;
        }
    }

    private boolean registerMessageTryBasicConstructor(Class<? extends Message> clazz) {
        String spec = this.getSpecString(clazz);
        try {
            Constructor<? extends Message> constructor = clazz.getConstructor(MessageAddress.class);
            this.noAttributeConstructors.put(spec, constructor);
            return true;
        }
        catch (NoSuchMethodException e) {
            log.error((Object)("Error while searching for message types. Does the " + clazz.getName() + " have a constructor with " + MessageAddress.class.getName() + " as an argument?"), (Throwable)e);
            return false;
        }
    }

    private String getSpecString(Class<? extends Message> messageClass) {
        MessageSpec messageSpec = messageClass.getAnnotation(MessageSpec.class);
        return messageSpec.value();
    }

    private String getDescription(Class<? extends Message> messageClass) {
        MessageSpec messageSpec = messageClass.getAnnotation(MessageSpec.class);
        return messageSpec.description();
    }
}

