/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.common.messaging;

import com.hazelcast.stabilizer.common.messaging.MessageAddress;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageAddressParser {
    public static final String AGENT = "Agent";
    public static final String WORKER = "Worker";
    public static final String TEST = "Test";
    public static final String ALL_WORKERS = "*";
    public static final String WORKERS_WITH_MEMBER = "*m";
    public static final String RANDOM_WORKER = "R";
    public static final String RANDOM_WORKER_WITH_MEMBER = "Rm";
    public static final String OLDEST_MEMBER = "O";
    public static final String ADDRESS_SEPARATOR = ",";

    public MessageAddress parse(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input string cannot be null");
        }
        Pattern pattern = Pattern.compile("(Agent=)(\\*|R)(,Worker=)?(\\*|R|O|\\*m|Rm)?(,Test=)?(\\*|R)?");
        Matcher matcher = pattern.matcher(input);
        MessageAddress.MessageAddressBuilder builder = MessageAddress.builder();
        ParserState state = ParserState.START;
        if (!matcher.matches()) {
            throw this.wrongFormat(input);
        }
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            String group = matcher.group(i);
            if (group == null) {
                if (EnumSet.of(ParserState.AFTER_AGENT_ADDRESS, ParserState.AFTER_WORKER_ADDRESS).contains((Object)state)) {
                    state = ParserState.DONE;
                    break;
                }
                throw this.wrongFormat(input);
            }
            if (state.equals((Object)ParserState.START)) {
                if ("Agent=".equals(group)) {
                    state = ParserState.BEFORE_AGENT_ADDRESS;
                    continue;
                }
                throw this.wrongFormat(input);
            }
            if (state.equals((Object)ParserState.BEFORE_AGENT_ADDRESS)) {
                if (group.equals(ALL_WORKERS)) {
                    builder.toAllAgents();
                } else if (group.equals(RANDOM_WORKER)) {
                    builder.toRandomAgent();
                } else {
                    throw this.wrongFormat(input);
                }
                state = ParserState.AFTER_AGENT_ADDRESS;
                continue;
            }
            if (state.equals((Object)ParserState.AFTER_AGENT_ADDRESS)) {
                if (group.equals(",Worker=")) {
                    state = ParserState.BEFORE_WORKER_ADDRESS;
                    continue;
                }
                throw this.wrongFormat(input);
            }
            if (state.equals((Object)ParserState.BEFORE_WORKER_ADDRESS)) {
                if (group.equals(ALL_WORKERS)) {
                    builder.toAllWorkers();
                } else if (group.equals(RANDOM_WORKER)) {
                    builder.toRandomWorker();
                } else if (group.equals(OLDEST_MEMBER)) {
                    builder.toOldestMember();
                } else if (group.equals(WORKERS_WITH_MEMBER)) {
                    builder.toWorkersWithClusterMember();
                } else if (group.equals(RANDOM_WORKER_WITH_MEMBER)) {
                    builder.toRandomWorkerWithMember();
                } else {
                    throw this.wrongFormat(input);
                }
                state = ParserState.AFTER_WORKER_ADDRESS;
                continue;
            }
            if (state.equals((Object)ParserState.AFTER_WORKER_ADDRESS)) {
                if (group.equals(",Test=")) {
                    state = ParserState.BEFORE_TEST_ADDRESS;
                    continue;
                }
                throw this.wrongFormat(input);
            }
            if (state.equals((Object)ParserState.BEFORE_TEST_ADDRESS)) {
                if (group.equals(ALL_WORKERS)) {
                    builder.toAllTests();
                } else if (group.equals(RANDOM_WORKER)) {
                    builder.toRandomTest();
                } else {
                    throw this.wrongFormat(input);
                }
                state = ParserState.DONE;
                continue;
            }
            throw this.wrongFormat(input);
        }
        if (!ParserState.DONE.equals((Object)state)) {
            throw this.wrongFormat(input);
        }
        return builder.build();
    }

    private RuntimeException wrongFormat(String address) {
        return new IllegalArgumentException(String.format("Address '%s' has a wrong format. Please use communicator --help to see the syntax", address));
    }

    private static enum ParserState {
        START,
        BEFORE_AGENT_ADDRESS,
        AFTER_AGENT_ADDRESS,
        BEFORE_WORKER_ADDRESS,
        AFTER_WORKER_ADDRESS,
        BEFORE_TEST_ADDRESS,
        AFTER_TEST_ADDRESS,
        DONE;

    }
}

