/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.common.messaging;

import java.io.Serializable;

public class MessageAddress
implements Serializable {
    public static final String BROADCAST = "*";
    public static final String RANDOM = "R";
    public static final String ALL_WORKERS_WITH_MEMBER = "*m";
    public static final String RANDOM_WORKER_WITH_MEMBER = "Rm";
    public static final String WORKER_WITH_OLDEST_MEMBER = "O";
    private String agentAddress;
    private String workerAddress;
    private String testAddress;

    public MessageAddress(String agentAddress, String workerAddress, String testAddress) {
        this.agentAddress = agentAddress;
        this.workerAddress = workerAddress;
        this.testAddress = testAddress;
    }

    public String getAgentAddress() {
        return this.agentAddress;
    }

    public String getWorkerAddress() {
        return this.workerAddress;
    }

    public String getTestAddress() {
        return this.testAddress;
    }

    public static MessageAddressBuilder builder() {
        return new MessageAddressBuilder();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MessageAddress{");
        if (this.agentAddress != null) {
            builder.append("agentAddress='").append(this.agentAddress).append("'");
        }
        if (this.workerAddress != null) {
            builder.append(",workerAddress='").append(this.workerAddress).append("'");
        }
        if (this.testAddress != null) {
            builder.append(",testAddress='").append(this.testAddress).append("'");
        }
        builder.append("}");
        return builder.toString();
    }

    public static class MessageAddressBuilder {
        private String agentAddress;
        private String workerAddress;
        private String testAddress;

        public MessageAddressBuilder toAllAgents() {
            this.agentAddress = MessageAddress.BROADCAST;
            return this;
        }

        public MessageAddressBuilder toRandomAgent() {
            this.agentAddress = MessageAddress.RANDOM;
            return this;
        }

        public MessageAddressBuilder toAllWorkers() {
            this.workerAddress = MessageAddress.BROADCAST;
            return this;
        }

        public MessageAddressBuilder toRandomWorker() {
            this.workerAddress = MessageAddress.RANDOM;
            return this;
        }

        public MessageAddressBuilder toOldestMember() {
            if (this.agentAddress == null) {
                this.agentAddress = MessageAddress.BROADCAST;
            }
            this.workerAddress = MessageAddress.WORKER_WITH_OLDEST_MEMBER;
            return this;
        }

        public MessageAddressBuilder toWorkersWithClusterMember() {
            if (this.agentAddress == null) {
                this.agentAddress = MessageAddress.BROADCAST;
            }
            this.workerAddress = MessageAddress.ALL_WORKERS_WITH_MEMBER;
            return this;
        }

        public MessageAddressBuilder toRandomWorkerWithMember() {
            if (this.agentAddress == null) {
                this.agentAddress = MessageAddress.BROADCAST;
            }
            this.workerAddress = MessageAddress.RANDOM_WORKER_WITH_MEMBER;
            return this;
        }

        public MessageAddressBuilder toAllTests() {
            this.testAddress = MessageAddress.BROADCAST;
            return this;
        }

        public MessageAddressBuilder toRandomTest() {
            this.testAddress = MessageAddress.RANDOM;
            return this;
        }

        public MessageAddress build() {
            this.validate();
            return new MessageAddress(this.agentAddress, this.workerAddress, this.testAddress);
        }

        private void validate() {
            if (this.agentAddress == null && this.workerAddress != null) {
                throw new IllegalStateException("Agent address cannot be empty when worker address is specified");
            }
            if (this.workerAddress == null && this.testAddress != null) {
                throw new IllegalStateException("Worker address cannot be empty when test address is specified");
            }
        }
    }
}

