/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.common;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class StabilizerProperties {
    private static final ILogger log = Logger.getLogger(StabilizerProperties.class);
    private final Properties properties = new Properties();

    public StabilizerProperties() {
        File defaultPropsFile = Utils.newFile(Utils.getStablizerHome(), "conf", "stabilizer.properties");
        log.finest("Loading default stabilizer.properties from: " + defaultPropsFile.getAbsolutePath());
        this.load(defaultPropsFile);
    }

    public void init(File file) {
        if (file == null) {
            File fallbackPropsFile = new File("stabilizer.properties");
            if (fallbackPropsFile.exists()) {
                file = fallbackPropsFile;
            } else {
                log.warning(String.format("%s is not found, relying on defaults", fallbackPropsFile));
            }
        }
        if (file != null) {
            log.info(String.format("Loading stabilizer.properties: %s", file.getAbsolutePath()));
            this.load(file);
        }
    }

    private void load(File file) {
        if (!file.exists()) {
            Utils.exitWithError(log, "Could not find stabilizer.properties file:  " + file.getAbsolutePath());
            return;
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            try {
                this.properties.load(inputStream);
            }
            catch (IOException e) {
                Utils.closeQuietly((Closeable)inputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String get(String name) {
        String value = (String)this.properties.get(name);
        if ("CLOUD_IDENTITY".equals(name)) {
            value = this.load("CLOUD_IDENTITY", value);
        } else if ("CLOUD_CREDENTIAL".equals(name)) {
            value = this.load("CLOUD_CREDENTIAL", value);
        }
        return value;
    }

    public String get(String name, String defaultValue) {
        String value = System.getProperty(name);
        if (value != null) {
            return value;
        }
        value = (String)this.properties.get(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private String load(String property, String value) {
        File file = Utils.newFile(value);
        if (!file.exists()) {
            Utils.exitWithError(log, String.format("Can't find %s file %s", property, value));
        }
        if (log.isFinestEnabled()) {
            log.finest("Loading " + property + " from file: " + file.getAbsolutePath());
        }
        return Utils.fileAsText(file).trim();
    }
}

