/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.common;

import com.hazelcast.stabilizer.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class GitInfo {
    private static final String GIT_INFO_FILE = "stabilizer-git.properties";
    private static final String UNKNOWN = "Unknown";
    private static final String GIT_COMMIT_ID_AABREV = "git.commit.id.abbrev";
    private static final String GIT_COMMIT_ID = "git.commit.id";
    private static final String GIT_COMMIT_TIME = "git.commit.time";
    private static final String GIT_BUILD_TIME = "git.build.time";
    private static final String GIT_REMOTE_ORIGIN_URL = "git.remote.origin.url";
    private static final Logger log = Logger.getLogger(GitInfo.class);
    private final Properties properties = this.loadGitProperties();
    private static final GitInfo INSTANCE = new GitInfo();

    private GitInfo() {
    }

    public static String getCommitIdAbbrev() {
        return GitInfo.INSTANCE.properties.getProperty(GIT_COMMIT_ID_AABREV, UNKNOWN);
    }

    public static String getCommitId() {
        return GitInfo.INSTANCE.properties.getProperty(GIT_COMMIT_ID, UNKNOWN);
    }

    public static String getCommitTime() {
        return GitInfo.INSTANCE.properties.getProperty(GIT_COMMIT_TIME, UNKNOWN);
    }

    public static String getBuildTime() {
        return GitInfo.INSTANCE.properties.getProperty(GIT_BUILD_TIME, UNKNOWN);
    }

    public static String getRemoteOriginUrl() {
        return GitInfo.INSTANCE.properties.getProperty(GIT_REMOTE_ORIGIN_URL, UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadGitProperties() {
        Properties properties = new Properties();
        InputStream gitPropsStream = null;
        try {
            gitPropsStream = this.getClass().getClassLoader().getResourceAsStream(GIT_INFO_FILE);
            properties.load(gitPropsStream);
        }
        catch (IOException e) {
            try {
                log.warn((Object)"Error while loading Git properties.", (Throwable)e);
                properties = new DummyProperties();
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(gitPropsStream);
                throw throwable;
            }
            Utils.closeQuietly((Closeable)gitPropsStream);
        }
        Utils.closeQuietly((Closeable)gitPropsStream);
        return properties;
    }

    private static class DummyProperties
    extends Properties {
        private DummyProperties() {
        }

        @Override
        public String getProperty(String key) {
            return GitInfo.UNKNOWN;
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            return defaultValue;
        }
    }
}

