/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.common;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.common.AgentAddress;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class AgentsFile {
    private static final ILogger log = Logger.getLogger(AgentsFile.class);

    public static void save(File agentsFile, List<AgentAddress> addresses) {
        StringBuffer sb = new StringBuffer();
        for (AgentAddress agentAddress : addresses) {
            if (agentAddress.publicAddress.equals(agentAddress.privateAddress)) {
                sb.append(agentAddress.publicAddress).append('\n');
                continue;
            }
            sb.append(agentAddress.publicAddress).append(',').append(agentAddress.privateAddress).append('\n');
        }
        Utils.writeText(sb.toString(), agentsFile);
    }

    public static List<AgentAddress> load(File agentFile) {
        String content = Utils.fileAsText(agentFile);
        String[] addresses = content.split("\n");
        int lineNumber = 1;
        LinkedList<AgentAddress> pairs = new LinkedList<AgentAddress>();
        block4: for (String line : addresses) {
            String trimLine = line.trim();
            if (trimLine.isEmpty()) continue;
            String[] chunks = trimLine.split(",");
            switch (chunks.length) {
                case 1: {
                    pairs.add(new AgentAddress(chunks[0], chunks[0]));
                    continue block4;
                }
                case 2: {
                    pairs.add(new AgentAddress(chunks[0], chunks[1]));
                    continue block4;
                }
                default: {
                    log.severe(String.format("Line %s of file %s is invalid, it should contain 1 or 2 addresses separated by a comma, but contains %s", lineNumber, agentFile, chunks.length));
                    System.exit(1);
                }
            }
        }
        return pairs;
    }
}

