/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.common;

public class AgentAddress {
    public final String publicAddress;
    public final String privateAddress;

    public AgentAddress(String publicAddress, String privateAddress) {
        if (publicAddress == null) {
            throw new NullPointerException("publicAddress can't be null");
        }
        if (privateAddress == null) {
            throw new NullPointerException("privateAddress can't be null");
        }
        this.publicAddress = publicAddress;
        this.privateAddress = privateAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentAddress address = (AgentAddress)o;
        if (!this.privateAddress.equals(address.privateAddress)) {
            return false;
        }
        return this.publicAddress.equals(address.publicAddress);
    }

    public int hashCode() {
        int result = this.publicAddress.hashCode();
        result = 31 * result + this.privateAddress.hashCode();
        return result;
    }

    public String toString() {
        return "AddressPair{publicAddress='" + this.publicAddress + '\'' + ", privateAddress='" + this.privateAddress + '\'' + '}';
    }
}

