/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.agent.workerjvm;

import com.hazelcast.stabilizer.NoWorkerAvailableException;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.Agent;
import com.hazelcast.stabilizer.agent.CommandFuture;
import com.hazelcast.stabilizer.agent.FailureAlreadyThrownRuntimeException;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvm;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmLauncher;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmSettings;
import com.hazelcast.stabilizer.common.messaging.Message;
import com.hazelcast.stabilizer.tests.Failure;
import com.hazelcast.stabilizer.worker.TerminateWorkerException;
import com.hazelcast.stabilizer.worker.commands.Command;
import com.hazelcast.stabilizer.worker.commands.CommandRequest;
import com.hazelcast.stabilizer.worker.commands.CommandResponse;
import com.hazelcast.stabilizer.worker.commands.MessageCommand;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class WorkerJvmManager {
    public static final String SERVICE_POLL_WORK = "poll";
    public static final String COMMAND_PUSH_RESPONSE = "push";
    public static final int PORT = 9001;
    public static final File WORKERS_HOME = new File(Utils.getStablizerHome(), "workers");
    private static final Logger log = Logger.getLogger(WorkerJvmManager.class);
    private static final int WAIT_FOR_PROCESS_TERMINATION_TIMEOUT_MILLIS = 10000;
    private final ConcurrentMap<String, WorkerJvm> workerJvms = new ConcurrentHashMap<String, WorkerJvm>();
    private final Agent agent;
    private final ConcurrentMap<Long, CommandFuture> futureMap = new ConcurrentHashMap<Long, CommandFuture>();
    private final AtomicLong requestIdGenerator = new AtomicLong(0L);
    private ServerSocket serverSocket;
    private final Executor executor = Executors.newFixedThreadPool(20);
    private Random random = new Random();
    private volatile WorkerJvmSettings lastUsedWorkerJvmSettings;

    public WorkerJvmManager(Agent agent) {
        this.agent = agent;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WorkerJvmManager.this.terminateWorkers();
            }
        });
    }

    public void start() throws Exception {
        this.serverSocket = new ServerSocket(9001, 0, InetAddress.getByName(null));
        log.info((Object)("Started Worker JVM Socket on: " + this.serverSocket.getInetAddress().getHostAddress() + ":" + 9001));
        new AcceptorThread().start();
    }

    public Collection<WorkerJvm> getWorkerJvms() {
        return this.workerJvms.values();
    }

    public Object executeOnSingleWorker(Command command) throws Exception {
        List<Object> workers = new ArrayList(this.workerJvms.values());
        if (workers.isEmpty()) {
            throw new NoWorkerAvailableException("No worker JVM's found");
        }
        List results = this.executeOnWorkers(command, workers = Collections.singletonList(workers.get(0)));
        if (results.isEmpty()) {
            log.info((Object)"No results found");
            return null;
        }
        return results.get(0);
    }

    public void sendMessage(Message message) throws TimeoutException, InterruptedException {
        String workerAddress = message.getMessageAddress().getWorkerAddress();
        if ("*".equals(workerAddress)) {
            this.sendMessageToAllWorkers(message);
        } else if ("O".equals(workerAddress)) {
            this.sendMessageToAllWorkers(message);
        } else if ("R".equals(workerAddress)) {
            this.sendMessageToRandomWorker(message);
        } else if ("*m".equals(workerAddress)) {
            this.sendMessageToAllWorkersWithClusterMember(message);
        } else if ("Rm".equals(workerAddress)) {
            this.sendMessageToRandomWorkerWithClusterMember(message);
        } else {
            throw new UnsupportedOperationException("Unsupported addressing mode for worker '" + workerAddress + "'. " + "Full address: '" + message.getMessageAddress() + "'.");
        }
    }

    private void sendMessageToRandomWorkerWithClusterMember(Message message) throws TimeoutException, InterruptedException {
        WorkerJvm worker = this.getRandomWorkerWithClusterMemberOrNull();
        if (worker == null) {
            log.warn((Object)"No worker is known to this agent. Is it a race-condition?");
        } else {
            List<WorkerJvm> workerList = Collections.singletonList(worker);
            this.preprocessMessage(message, workerList);
            MessageCommand command = new MessageCommand(message);
            this.executeOnWorkers(command, workerList);
        }
    }

    private void sendMessageToAllWorkersWithClusterMember(Message message) throws TimeoutException, InterruptedException {
        List<WorkerJvm> workers = this.getAllWorkersWithClusterMembers();
        this.preprocessMessage(message, workers);
        this.executeOnWorkers(new MessageCommand(message), workers);
    }

    private void sendMessageToRandomWorker(Message message) throws TimeoutException, InterruptedException {
        WorkerJvm randomWorker = this.getRandomWorkerOrNull();
        if (randomWorker == null) {
            log.warn((Object)"No worker is known to this agent. Is it a race-condition?");
        } else {
            List<WorkerJvm> workerJvmList = Arrays.asList(randomWorker);
            this.preprocessMessage(message, workerJvmList);
            MessageCommand command = new MessageCommand(message);
            this.executeOnWorkers(command, workerJvmList);
        }
    }

    private void preprocessMessage(Message message, Collection<WorkerJvm> workerJvmList) {
        for (WorkerJvm workerJvm : new ArrayList<WorkerJvm>(workerJvmList)) {
            if (message.removeFromAgentList()) {
                while (this.workerJvms.values().remove(workerJvm)) {
                }
                continue;
            }
            if (!message.disableMemberFailureDetection()) continue;
            workerJvm.detectFailure = false;
        }
    }

    private void sendMessageToAllWorkers(Message message) throws TimeoutException, InterruptedException {
        MessageCommand command = new MessageCommand(message);
        Collection<WorkerJvm> workerJvmList = this.workerJvms.values();
        this.preprocessMessage(message, workerJvmList);
        this.executeOnWorkers(command, workerJvmList);
    }

    public List executeOnAllWorkers(Command command) throws TimeoutException, InterruptedException {
        return this.executeOnWorkers(command, this.workerJvms.values());
    }

    private List executeOnWorkers(Command command, Collection<WorkerJvm> workers) throws TimeoutException, InterruptedException {
        HashMap futures = new HashMap();
        for (WorkerJvm workerJvm : workers) {
            if (workerJvm.oomeDetected) continue;
            CommandFuture future = new CommandFuture(command);
            CommandRequest request = new CommandRequest();
            request.id = this.requestIdGenerator.incrementAndGet();
            request.task = command;
            if (command.awaitReply()) {
                this.futureMap.put(request.id, future);
                futures.put(workerJvm, future);
            }
            workerJvm.commandQueue.add(request);
        }
        LinkedList results = new LinkedList();
        for (Map.Entry entry : futures.entrySet()) {
            WorkerJvm workerJvm = (WorkerJvm)entry.getKey();
            Future future = (Future)entry.getValue();
            try {
                Object result = future.get(30L, TimeUnit.SECONDS);
                results.add(result);
            }
            catch (ExecutionException e) {
                Failure failure = new Failure();
                failure.type = Failure.Type.WORKER_EXCEPTION;
                failure.message = e.getMessage();
                failure.agentAddress = Utils.getHostAddress();
                failure.workerAddress = workerJvm.memberAddress;
                failure.workerId = workerJvm.id;
                failure.testSuite = this.agent.getTestSuite();
                failure.cause = Utils.throwableToString(e);
                this.agent.getWorkerJvmFailureMonitor().publish(failure);
                throw new FailureAlreadyThrownRuntimeException(e);
            }
        }
        return results;
    }

    public void spawn(WorkerJvmSettings settings) throws Exception {
        if (this.workerJvms.size() > 0) {
            this.terminateWorkers();
        }
        this.lastUsedWorkerJvmSettings = settings;
        WorkerJvmLauncher launcher = new WorkerJvmLauncher(this.agent, this.workerJvms, settings);
        launcher.launch();
    }

    public void terminateWorkers() {
        log.info((Object)"Terminating workers");
        for (WorkerJvm jvm : new LinkedList(this.workerJvms.values())) {
            this.terminateWorker(jvm);
        }
        log.info((Object)"Finished terminating workers");
    }

    public void terminateRandomWorker() {
        WorkerJvm randomWorker = this.getRandomWorkerOrNull();
        if (randomWorker == null) {
            log.warn((Object)"Attempt to terminating a random worker detected, but no worker is running.");
            return;
        }
        this.terminateWorker(randomWorker);
    }

    public void terminateWorker(final WorkerJvm jvm) {
        this.workerJvms.remove(jvm.id);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    jvm.process.destroy();
                    jvm.process.waitFor();
                }
                catch (Throwable e) {
                    log.fatal((Object)("Failed to destroy worker process: " + jvm));
                }
            }
        };
        t.start();
        try {
            t.join(10000L);
            if (t.isAlive()) {
                log.warn((Object)("WorkerJVM is still busy terminating: " + jvm));
            }
        }
        catch (Exception e) {
            log.fatal((Object)e);
        }
    }

    private WorkerJvm getRandomWorkerWithClusterMemberOrNull() {
        List<WorkerJvm> jvmCollection = this.withoutMode(this.workerJvms.values(), WorkerJvm.Mode.CLIENT);
        if (jvmCollection.isEmpty()) {
            return null;
        }
        WorkerJvm[] workers = jvmCollection.toArray(new WorkerJvm[jvmCollection.size()]);
        return workers[this.random.nextInt(workers.length)];
    }

    private List<WorkerJvm> getAllWorkersWithClusterMembers() {
        List<WorkerJvm> jvmCollection = this.withoutMode(this.workerJvms.values(), WorkerJvm.Mode.CLIENT);
        return jvmCollection;
    }

    public List<WorkerJvm> withoutMode(Iterable<WorkerJvm> source, WorkerJvm.Mode mode) {
        ArrayList<WorkerJvm> result = new ArrayList<WorkerJvm>();
        for (WorkerJvm workerJvm : source) {
            if (workerJvm.mode.equals((Object)mode)) continue;
            result.add(workerJvm);
        }
        return result;
    }

    private WorkerJvm getRandomWorkerOrNull() {
        Collection jvmCollection = this.workerJvms.values();
        if (jvmCollection.isEmpty()) {
            return null;
        }
        WorkerJvm[] workers = jvmCollection.toArray(new WorkerJvm[jvmCollection.size()]);
        return workers[this.random.nextInt(workers.length)];
    }

    public void newMember() throws Exception {
        log.info((Object)"Adding a newMember");
        WorkerJvmSettings lastUsedWorkerJvmSettings = this.lastUsedWorkerJvmSettings;
        if (lastUsedWorkerJvmSettings == null) {
            log.warn((Object)"No lastUsedWorkerJvmSettings available");
            return;
        }
        WorkerJvmSettings settings = new WorkerJvmSettings(lastUsedWorkerJvmSettings);
        settings.memberWorkerCount = 1;
        settings.clientWorkerCount = 0;
        settings.mixedWorkerCount = 0;
        WorkerJvmLauncher launcher = new WorkerJvmLauncher(this.agent, this.workerJvms, settings);
        launcher.launch();
    }

    private class AcceptorThread
    extends Thread {
        public AcceptorThread() {
            super("AcceptorThread");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Socket clientSocket = WorkerJvmManager.this.serverSocket.accept();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Accepted worker request from: " + clientSocket.getRemoteSocketAddress()));
                        }
                        WorkerJvmManager.this.executor.execute(new ClientSocketTask(clientSocket));
                    }
                }
                catch (Throwable e) {
                    log.fatal((Object)e);
                    continue;
                }
                break;
            }
        }
    }

    private class ClientSocketTask
    implements Runnable {
        private final Socket clientSocket;

        private ClientSocketTask(Socket clientSocket) {
            this.clientSocket = clientSocket;
        }

        @Override
        public void run() {
            try {
                Serializable result;
                ObjectOutputStream out;
                block10: {
                    out = new ObjectOutputStream(this.clientSocket.getOutputStream());
                    out.flush();
                    ObjectInputStream in = new ObjectInputStream(this.clientSocket.getInputStream());
                    String service = (String)in.readObject();
                    String workerId = (String)in.readObject();
                    WorkerJvm workerJvm = (WorkerJvm)WorkerJvmManager.this.workerJvms.get(workerId);
                    result = null;
                    try {
                        if (workerJvm == null) {
                            log.warn((Object)("No worker JVM found for id: " + workerId));
                            result = new TerminateWorkerException();
                            break block10;
                        }
                        workerJvm.lastSeen = System.currentTimeMillis();
                        if (WorkerJvmManager.SERVICE_POLL_WORK.equals(service)) {
                            LinkedList commands = new LinkedList();
                            workerJvm.commandQueue.drainTo(commands);
                            result = commands;
                            break block10;
                        }
                        if (WorkerJvmManager.COMMAND_PUSH_RESPONSE.equals(service)) {
                            CommandResponse response = (CommandResponse)in.readObject();
                            CommandFuture f = (CommandFuture)WorkerJvmManager.this.futureMap.remove(response.commandId);
                            if (f != null) {
                                f.set(response.result);
                            } else {
                                log.fatal((Object)("No future found for commandId: " + response.commandId));
                            }
                            break block10;
                        }
                        throw new RuntimeException("Unknown service:" + service);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        log.fatal((Object)("Failed to process serviceId:" + service), (Throwable)e);
                        result = e;
                    }
                }
                out.writeObject(result);
                out.flush();
                this.clientSocket.close();
            }
            catch (Exception e) {
                log.fatal((Object)e);
            }
        }
    }
}

