/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.agent.workerjvm;

import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.Agent;
import com.hazelcast.stabilizer.agent.SpawnWorkerFailedException;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvm;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmProcessOutputGobbler;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmSettings;
import com.hazelcast.stabilizer.worker.Worker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class WorkerJvmLauncher {
    private static final Logger log = Logger.getLogger(WorkerJvmLauncher.class);
    private final AtomicBoolean javaHomePrinted = new AtomicBoolean();
    private static final String CLASSPATH = System.getProperty("java.class.path");
    private static final File STABILIZER_HOME = Utils.getStablizerHome();
    private static final String CLASSPATH_SEPARATOR = System.getProperty("path.separator");
    private static final AtomicLong WORKER_ID_GENERATOR = new AtomicLong();
    private final WorkerJvmSettings settings;
    private final Agent agent;
    private final ConcurrentMap<String, WorkerJvm> workerJvms;
    private File hzFile;
    private File clientHzFile;
    private final List<WorkerJvm> workersInProgress = new LinkedList<WorkerJvm>();
    private File testSuiteDir;

    public WorkerJvmLauncher(Agent agent, ConcurrentMap<String, WorkerJvm> workerJvms, WorkerJvmSettings settings) {
        this.settings = settings;
        this.workerJvms = workerJvms;
        this.agent = agent;
    }

    public void launch() throws Exception {
        this.hzFile = this.createHzConfigFile();
        this.clientHzFile = this.createClientHzConfigFile();
        this.testSuiteDir = this.agent.getTestSuiteDir();
        if (!this.testSuiteDir.exists() && !this.testSuiteDir.mkdirs()) {
            throw new SpawnWorkerFailedException("Couldn't create testSuiteDir: " + this.testSuiteDir.getAbsolutePath());
        }
        log.info((Object)("Spawning Worker JVM using settings: " + this.settings));
        this.spawn(this.settings.memberWorkerCount, "server");
        this.spawn(this.settings.clientWorkerCount, "client");
        this.spawn(this.settings.mixedWorkerCount, "mixed");
    }

    private void spawn(int count, String mode) throws Exception {
        log.info((Object)String.format("Starting %s %s worker Java Virtual Machines", count, mode));
        for (int k = 0; k < count; ++k) {
            WorkerJvm worker = this.startWorkerJvm(mode);
            this.workersInProgress.add(worker);
        }
        log.info((Object)String.format("Finished starting %s %s worker Java Virtual Machines", count, mode));
        this.waitForWorkersStartup(this.workersInProgress, this.settings.workerStartupTimeout);
        this.workersInProgress.clear();
    }

    private File createHzConfigFile() throws IOException {
        File hzConfigFile = File.createTempFile("hazelcast", "xml");
        hzConfigFile.deleteOnExit();
        Utils.writeText(this.settings.hzConfig, hzConfigFile);
        return hzConfigFile;
    }

    private File createClientHzConfigFile() throws IOException {
        File clientHzConfigFile = File.createTempFile("client-hazelcast", "xml");
        clientHzConfigFile.deleteOnExit();
        Utils.writeText(this.settings.clientHzConfig, clientHzConfigFile);
        return clientHzConfigFile;
    }

    private String getJavaHome(String javaVendor, String javaVersion) {
        String javaHome = System.getProperty("java.home");
        if (this.javaHomePrinted.compareAndSet(false, true)) {
            log.info((Object)("java.home=" + javaHome));
        }
        return javaHome;
    }

    private WorkerJvm startWorkerJvm(String mode) throws IOException {
        String workerId = "worker-" + Utils.getHostAddress() + "-" + WORKER_ID_GENERATOR.incrementAndGet() + "-" + mode;
        File workerHome = new File(this.testSuiteDir, workerId);
        if (!workerHome.exists() && !workerHome.mkdir()) {
            throw new SpawnWorkerFailedException("Could not create workerhome: " + workerHome.getAbsolutePath());
        }
        String javaHome = this.getJavaHome(this.settings.javaVendor, this.settings.javaVersion);
        WorkerJvm workerJvm = new WorkerJvm(workerId);
        workerJvm.workerHome = workerHome;
        String[] args = this.buildArgs(workerJvm, mode);
        ProcessBuilder processBuilder = new ProcessBuilder(args).directory(workerHome).redirectErrorStream(true);
        Map<String, String> environment = processBuilder.environment();
        String path = javaHome + File.pathSeparator + "bin:" + environment.get("PATH");
        environment.put("PATH", path);
        environment.put("JAVA_HOME", javaHome);
        Process process = processBuilder.start();
        File logFile = new File(workerHome, "out.log");
        new WorkerJvmProcessOutputGobbler(process.getInputStream(), new FileOutputStream(logFile)).start();
        workerJvm.process = process;
        workerJvm.mode = WorkerJvm.Mode.valueOf(mode.toUpperCase());
        this.workerJvms.put(workerId, workerJvm);
        return workerJvm;
    }

    private String getClasspath() {
        File libDir = new File(this.agent.getTestSuiteDir(), "lib");
        return CLASSPATH + CLASSPATH_SEPARATOR + new File(libDir, "*").getAbsolutePath();
    }

    private List<String> getJvmOptions(WorkerJvmSettings settings) {
        String workerVmOptions = settings.vmOptions;
        String[] clientVmOptionsArray = new String[]{};
        if (workerVmOptions != null && !workerVmOptions.trim().isEmpty()) {
            clientVmOptionsArray = workerVmOptions.split("\\s+");
        }
        return Arrays.asList(clientVmOptionsArray);
    }

    private String[] buildArgs(WorkerJvm workerJvm, String mode) {
        LinkedList<String> args = new LinkedList<String>();
        args.add("java");
        if ("yourkit".equals(this.settings.profiler)) {
            String agentSetting = this.settings.yourkitConfig.replace("${STABILIZER_HOME}", STABILIZER_HOME.getAbsolutePath()).replace("${WORKER_HOME}", workerJvm.workerHome.getAbsolutePath());
            args.add(agentSetting);
        } else if ("hprof".equals(this.settings.profiler)) {
            args.add(this.settings.hprofSettings);
        }
        args.add("-XX:OnOutOfMemoryError=\"\"touch worker.oome\"\"");
        args.add("-DSTABILIZER_HOME=" + STABILIZER_HOME);
        args.add("-Dhazelcast.logging.type=log4j");
        args.add("-DworkerId=" + workerJvm.id);
        args.add("-DworkerMode=" + mode);
        args.add("-Dlog4j.configuration=file:" + STABILIZER_HOME + File.separator + "conf" + File.separator + "worker-log4j.xml");
        args.add("-classpath");
        args.add(this.getClasspath());
        args.addAll(this.getJvmOptions(this.settings));
        args.add(Worker.class.getName());
        args.add(this.hzFile.getAbsolutePath());
        args.add(this.clientHzFile.getAbsolutePath());
        return args.toArray(new String[args.size()]);
    }

    private boolean hasExited(WorkerJvm workerJvm) {
        try {
            workerJvm.process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    private void waitForWorkersStartup(List<WorkerJvm> workers, int workerTimeoutSec) throws InterruptedException {
        ArrayList<WorkerJvm> todo = new ArrayList<WorkerJvm>(workers);
        for (int l = 0; l < workerTimeoutSec; ++l) {
            Iterator it = todo.iterator();
            while (it.hasNext()) {
                WorkerJvm jvm = (WorkerJvm)it.next();
                if (this.hasExited(jvm)) {
                    String message = String.format("Startup failure: worker on host %s failed during startup, check '%s/out.log' for more info", Utils.getHostAddress(), jvm.workerHome);
                    throw new SpawnWorkerFailedException(message);
                }
                String address = this.readAddress(jvm);
                if (address == null) continue;
                jvm.memberAddress = address;
                it.remove();
                log.info((Object)String.format("Worker: %s Started %s of %s", jvm.id, workers.size() - todo.size(), workers.size()));
            }
            if (todo.isEmpty()) {
                return;
            }
            Utils.sleepSeconds(1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(((WorkerJvm)todo.get((int)0)).id);
        for (int l = 1; l < todo.size(); ++l) {
            sb.append(",").append(((WorkerJvm)todo.get((int)l)).id);
        }
        sb.append("]");
        throw new SpawnWorkerFailedException(String.format("Timeout: workers %s of testsuite %s on host %s didn't start within %s seconds", sb, this.agent.getTestSuite().id, Utils.getHostAddress(), workerTimeoutSec));
    }

    private String readAddress(WorkerJvm jvm) {
        File file = new File(jvm.workerHome, "worker.address");
        if (!file.exists()) {
            return null;
        }
        String address = (String)Utils.readObject(file);
        file.delete();
        return address;
    }
}

