/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.agent.workerjvm;

import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.Agent;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvm;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmManager;
import com.hazelcast.stabilizer.tests.Failure;
import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class WorkerJvmFailureMonitor {
    private static final Logger log = Logger.getLogger(WorkerJvmFailureMonitor.class);
    private static final int LAST_SEEN_TIMEOUT_MS = 60000;
    private final Agent agent;
    private final BlockingQueue<Failure> failureQueue = new LinkedBlockingQueue<Failure>();
    private final FailureMonitorThread failureMonitorThread = new FailureMonitorThread();

    public WorkerJvmFailureMonitor(Agent agent) {
        this.agent = agent;
    }

    public void drainFailures(List<Failure> failures) {
        this.failureQueue.drainTo(failures);
    }

    public void publish(Failure failure) {
        log.warn((Object)("Failure detected: " + failure));
        this.failureQueue.add(failure);
    }

    public void start() {
        this.failureMonitorThread.start();
    }

    private void detect() {
        WorkerJvmManager workerJvmManager = this.agent.getWorkerJvmManager();
        for (WorkerJvm jvm : workerJvmManager.getWorkerJvms()) {
            if (!jvm.detectFailure) continue;
            this.detectFailuresInJvm(jvm);
        }
    }

    private void detectFailuresInJvm(WorkerJvm jvm) {
        LinkedList<Failure> failures = new LinkedList<Failure>();
        this.detectOomeFailure(jvm, failures);
        this.detectExceptions(jvm, failures);
        this.detectInactivity(jvm, failures);
        this.detectUnexpectedExit(jvm, failures);
        for (Failure failure : failures) {
            this.publish(failure);
        }
    }

    private void detectInactivity(WorkerJvm jvm, List<Failure> failures) {
        long currentMs = System.currentTimeMillis();
        if (jvm.oomeDetected) {
            return;
        }
        if (currentMs - 60000L > jvm.lastSeen) {
            Failure failure = new Failure();
            failure.message = "Worker has not contacted agent for a too long period.";
            failure.type = Failure.Type.WORKER_TIMEOUT;
            failure.agentAddress = Utils.getHostAddress();
            failure.workerAddress = jvm.memberAddress;
            failure.workerId = jvm.id;
            failure.testSuite = this.agent.getTestSuite();
            failures.add(failure);
        }
    }

    private void detectExceptions(WorkerJvm workerJvm, List<Failure> failures) {
        File workerHome = workerJvm.workerHome;
        if (!workerHome.exists()) {
            return;
        }
        File[] exceptionFiles = workerHome.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".exception");
            }
        });
        if (exceptionFiles == null) {
            return;
        }
        for (File exceptionFile : exceptionFiles) {
            String content = Utils.fileAsText(exceptionFile);
            int indexOf = content.indexOf("\n");
            String testId = content.substring(0, indexOf);
            String cause = content.substring(indexOf + 1);
            exceptionFile.delete();
            Failure failure = new Failure();
            failure.message = "Worked ran into an unhandled exception";
            failure.type = Failure.Type.WORKER_EXCEPTION;
            failure.agentAddress = Utils.getHostAddress();
            failure.workerAddress = workerJvm.memberAddress;
            failure.workerId = workerJvm.id;
            failure.testId = testId;
            failure.testSuite = this.agent.getTestSuite();
            failure.cause = cause;
            failures.add(failure);
        }
    }

    private void detectOomeFailure(WorkerJvm jvm, List<Failure> failures) {
        File oomeFile = new File(jvm.workerHome, "worker.oome");
        if (!oomeFile.exists()) {
            return;
        }
        jvm.oomeDetected = true;
        oomeFile.delete();
        Failure failure = new Failure();
        failure.message = "Worker ran into an Out Of Memory Error";
        failure.type = Failure.Type.WORKER_OOM;
        failure.agentAddress = Utils.getHostAddress();
        failure.workerAddress = jvm.memberAddress;
        failure.workerId = jvm.id;
        failure.testSuite = this.agent.getTestSuite();
        failures.add(failure);
    }

    private void detectUnexpectedExit(WorkerJvm jvm, List<Failure> failures) {
        int exitCode;
        if (jvm.oomeDetected) {
            return;
        }
        Process process = jvm.process;
        try {
            exitCode = process.exitValue();
        }
        catch (IllegalThreadStateException ignore) {
            return;
        }
        if (exitCode == 0) {
            return;
        }
        this.agent.getWorkerJvmManager().terminateWorker(jvm);
        Failure failure = new Failure();
        failure.message = "Worker terminated with exit code not 0, but  " + exitCode;
        failure.type = Failure.Type.WORKER_EXIT;
        failure.agentAddress = Utils.getHostAddress();
        failure.workerAddress = jvm.memberAddress;
        failure.workerId = jvm.id;
        failure.testSuite = this.agent.getTestSuite();
        failures.add(failure);
    }

    private class FailureMonitorThread
    extends Thread {
        public FailureMonitorThread() {
            super("FailureMonitorThread");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    WorkerJvmFailureMonitor.this.detect();
                }
                catch (Exception e) {
                    log.fatal((Object)"Failed to scan for failures", (Throwable)e);
                }
                Utils.sleepSeconds(1);
            }
        }
    }
}

