/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.agent.remoting;

import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.Agent;
import com.hazelcast.stabilizer.agent.remoting.AgentMessageProcessor;
import com.hazelcast.stabilizer.agent.remoting.AgentRemoteService;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvm;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmManager;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmSettings;
import com.hazelcast.stabilizer.common.messaging.Message;
import com.hazelcast.stabilizer.tests.Failure;
import com.hazelcast.stabilizer.tests.TestSuite;
import com.hazelcast.stabilizer.worker.commands.Command;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

class ClientSocketTask
implements Runnable {
    private static final Logger log = Logger.getLogger(ClientSocketTask.class);
    private final Socket clientSocket;
    private final Agent agent;
    private final AgentMessageProcessor agentMessageProcessor;

    ClientSocketTask(Socket clientSocket, Agent agent, AgentMessageProcessor agentMessageProcessor) {
        this.clientSocket = clientSocket;
        this.agent = agent;
        this.agentMessageProcessor = agentMessageProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        try {
            Object result;
            try {
                out = new ObjectOutputStream(this.clientSocket.getOutputStream());
                in = new ObjectInputStream(this.clientSocket.getInputStream());
                AgentRemoteService.Service service = (AgentRemoteService.Service)((Object)in.readObject());
                result = this.execute(service, in);
            }
            catch (Throwable e) {
                log.fatal((Object)e);
                result = e;
            }
            out.writeObject(result);
            out.flush();
        }
        catch (Throwable e) {
            try {
                log.fatal((Object)e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(in, out);
                Utils.closeQuietly(this.clientSocket);
                throw throwable;
            }
            Utils.closeQuietly(in, out);
            Utils.closeQuietly(this.clientSocket);
        }
        Utils.closeQuietly(in, out);
        Utils.closeQuietly(this.clientSocket);
    }

    private Object execute(AgentRemoteService.Service service, ObjectInputStream in) throws Exception {
        Object result = null;
        switch (service) {
            case SERVICE_POKE: {
                this.poke();
                break;
            }
            case SERVICE_SPAWN_WORKERS: {
                WorkerJvmSettings settings = (WorkerJvmSettings)in.readObject();
                this.spawnWorkers(settings);
                break;
            }
            case SERVICE_INIT_TESTSUITE: {
                TestSuite testSuite = (TestSuite)in.readObject();
                this.initTestSuite(testSuite);
                break;
            }
            case SERVICE_TERMINATE_WORKERS: {
                this.terminateWorkers();
                break;
            }
            case SERVICE_EXECUTE_ALL_WORKERS: {
                Command testCommand = (Command)in.readObject();
                WorkerJvmManager workerJvmManager = this.agent.getWorkerJvmManager();
                result = workerJvmManager.executeOnAllWorkers(testCommand);
                break;
            }
            case SERVICE_EXECUTE_SINGLE_WORKER: {
                Command testCommand = (Command)in.readObject();
                WorkerJvmManager workerJvmManager = this.agent.getWorkerJvmManager();
                result = workerJvmManager.executeOnSingleWorker(testCommand);
                break;
            }
            case SERVICE_ECHO: {
                String msg = (String)in.readObject();
                this.echo(msg);
                break;
            }
            case SERVICE_GET_FAILURES: {
                result = this.getFailures();
                break;
            }
            case SERVICE_GET_ALL_WORKERS: {
                result = new ArrayList();
                Collection<WorkerJvm> workerJvms = this.agent.getWorkerJvmManager().getWorkerJvms();
                for (WorkerJvm workerJvm : workerJvms) {
                    ((List)result).add(workerJvm.id);
                }
                break;
            }
            case SERVICE_PROCESS_MESSAGE: {
                Message message = (Message)in.readObject();
                this.agentMessageProcessor.submit(message);
                break;
            }
            default: {
                throw new RuntimeException("Unknown service:" + (Object)((Object)service));
            }
        }
        return result;
    }

    private void poke() {
        log.info((Object)"Poked by coordinator");
    }

    private ArrayList<Failure> getFailures() {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        this.agent.getWorkerJvmFailureMonitor().drainFailures(failures);
        return failures;
    }

    private void spawnWorkers(WorkerJvmSettings settings) throws Exception {
        try {
            this.agent.getWorkerJvmManager().spawn(settings);
        }
        catch (Exception e) {
            log.fatal((Object)("Failed to spawn workers from settings:" + settings), (Throwable)e);
            throw e;
        }
    }

    private void initTestSuite(TestSuite testSuite) throws Exception {
        try {
            this.agent.initTestSuite(testSuite);
        }
        catch (Exception e) {
            log.fatal((Object)("Failed to init testsuite: " + testSuite), (Throwable)e);
            throw e;
        }
    }

    private void terminateWorkers() throws Exception {
        try {
            this.agent.getWorkerJvmManager().terminateWorkers();
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to terminateWorker workers", (Throwable)e);
            throw e;
        }
    }

    private void echo(String msg) throws Exception {
        try {
            this.agent.echo(msg);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to echo", (Throwable)e);
            throw e;
        }
    }
}

