/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.agent.remoting;

import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.Agent;
import com.hazelcast.stabilizer.agent.remoting.AgentMessageProcessor;
import com.hazelcast.stabilizer.agent.remoting.ClientSocketTask;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class AgentRemoteService {
    public static final int PORT = 9000;
    private static final Logger log = Logger.getLogger((String)AgentRemoteService.class.getName());
    private final Agent agent;
    private final AgentMessageProcessor agentMessageProcessor;
    private ServerSocket serverSocket;
    private final Executor executor = Executors.newFixedThreadPool(20);
    private AcceptorThread acceptorThread;

    public AgentRemoteService(Agent agent, AgentMessageProcessor agentMessageProcessor) {
        this.agent = agent;
        this.agentMessageProcessor = agentMessageProcessor;
    }

    public void start() throws IOException {
        this.serverSocket = new ServerSocket(9000, 0, InetAddress.getByName(Utils.getHostAddress()));
        log.info((Object)("Started Agent Remote Service on :" + this.serverSocket.getInetAddress().getHostAddress() + ":" + 9000));
        this.acceptorThread = new AcceptorThread();
        this.acceptorThread.start();
    }

    public void stop() throws IOException {
        this.acceptorThread.stopMe();
        this.serverSocket.close();
    }

    private class AcceptorThread
    extends Thread {
        private volatile boolean stopped;

        public AcceptorThread() {
            super("AcceptorThread");
            this.stopped = false;
        }

        public void stopMe() {
            this.stopped = true;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    Socket clientSocket = AgentRemoteService.this.serverSocket.accept();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Accepted coordinator request from: " + clientSocket.getRemoteSocketAddress()));
                    }
                    AgentRemoteService.this.agent.signalUsed();
                    AgentRemoteService.this.executor.execute(new ClientSocketTask(clientSocket, AgentRemoteService.this.agent, AgentRemoteService.this.agentMessageProcessor));
                }
                catch (IOException e) {
                    log.fatal((Object)e);
                }
            }
        }
    }

    public static enum Service {
        SERVICE_SPAWN_WORKERS,
        SERVICE_INIT_TESTSUITE,
        SERVICE_TERMINATE_WORKERS,
        SERVICE_EXECUTE_ALL_WORKERS,
        SERVICE_EXECUTE_SINGLE_WORKER,
        SERVICE_ECHO,
        SERVICE_POKE,
        SERVICE_GET_FAILURES,
        SERVICE_GET_ALL_WORKERS,
        SERVICE_PROCESS_MESSAGE;

    }
}

