/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.agent.remoting;

import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmManager;
import com.hazelcast.stabilizer.common.messaging.Message;
import com.hazelcast.stabilizer.common.messaging.MessageAddress;
import com.hazelcast.stabilizer.common.messaging.NewMemberMessage;
import com.hazelcast.stabilizer.common.messaging.TerminateRandomWorkerMessage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class AgentMessageProcessor {
    private static final Logger log = Logger.getLogger(AgentMessageProcessor.class);
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private WorkerJvmManager workerJvmManager;

    public AgentMessageProcessor(WorkerJvmManager workerJvmManager) {
        this.workerJvmManager = workerJvmManager;
    }

    public void submit(final Message message) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageAddress messageAddress = message.getMessageAddress();
                    if (AgentMessageProcessor.this.shouldProcess(message)) {
                        if (messageAddress.getWorkerAddress() == null) {
                            AgentMessageProcessor.this.processLocalMessage(message);
                        } else {
                            AgentMessageProcessor.this.processWorkerMessage(message);
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)("Failed to process message:" + message), t);
                }
            }
        });
    }

    private boolean shouldProcess(Message message) {
        return true;
    }

    private void processWorkerMessage(Message message) {
        try {
            this.workerJvmManager.sendMessage(message);
        }
        catch (TimeoutException e) {
            log.error((Object)e);
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
    }

    private void processLocalMessage(Message message) throws Exception {
        log.debug((Object)("Processing local message :" + message));
        if (message instanceof Runnable) {
            this.processLocalRunnableMessage((Runnable)((Object)message));
        } else if (message instanceof TerminateRandomWorkerMessage) {
            this.workerJvmManager.terminateRandomWorker();
        } else if (message instanceof NewMemberMessage) {
            this.workerJvmManager.newMember();
        } else {
            throw new UnsupportedOperationException("Unknown message type received: " + message.getClass().getName());
        }
    }

    private void processLocalRunnableMessage(Runnable message) {
        message.run();
    }
}

