/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.agent;

import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.JavaInstallation;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JavaInstallationsRepository {
    private final List<JavaInstallation> installationList = new LinkedList<JavaInstallation>();

    public JavaInstallation getAny() {
        if (this.installationList.isEmpty()) {
            return null;
        }
        return this.installationList.get(0);
    }

    public void load(File propertiesFile) {
        Properties properties = this.loadProperties(propertiesFile);
        HashMap<String, JavaInstallation> entries = new HashMap<String, JavaInstallation>();
        for (String string : properties.stringPropertyNames()) {
            String[] tokens = string.split("\\.");
            if (tokens.length != 2) {
                throw new RuntimeException(String.format("Invalid java-installations properties: property key [%s] should be of form x.y", string));
            }
            String value = properties.getProperty(string);
            String id = tokens[0];
            String property = tokens[1];
            JavaInstallation installation = (JavaInstallation)entries.get(id);
            if (installation == null) {
                installation = new JavaInstallation();
                entries.put(id, installation);
            }
            if ("vendor".equalsIgnoreCase(property)) {
                installation.setVendor(value);
                continue;
            }
            if ("version".equalsIgnoreCase(property)) {
                installation.setVersion(value);
                continue;
            }
            if ("javaHome".equalsIgnoreCase(property)) {
                installation.setJavaHome(value);
                continue;
            }
            throw new RuntimeException(String.format("Invalid java-installations properties: property key [%s] is not unrecognized", string));
        }
        for (Map.Entry entry : entries.entrySet()) {
            String id = (String)entry.getKey();
            JavaInstallation installation = (JavaInstallation)entry.getValue();
            if (installation.getVendor() == null) {
                throw new RuntimeException(String.format("Invalid java-installations properties: %s.vendor is missing", id));
            }
            if (installation.getVersion() == null) {
                throw new RuntimeException(String.format("Invalid java-installations properties: %s.version is missing", id));
            }
            if (installation.getJavaHome() == null) {
                throw new RuntimeException(String.format("Invalid java-installations properties: %s.javaHome is missing", id));
            }
            this.installationList.add(installation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File propertiesFile) {
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propertiesFile);
            try {
                properties.load(fis);
            }
            finally {
                Utils.closeQuietly((Closeable)fis);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public JavaInstallation get(String vendor, String version) {
        for (JavaInstallation installation : this.installationList) {
            if (!installation.getVendor().equals(vendor) || !installation.getVersion().equals(version)) continue;
            return installation;
        }
        return null;
    }
}

