/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.agent;

import com.hazelcast.stabilizer.agent.Agent;
import com.hazelcast.stabilizer.common.StabilizerProperties;
import com.hazelcast.stabilizer.provisioner.Bash;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class HarakiriMonitor
extends Thread {
    private static final Logger log = Logger.getLogger((String)HarakiriMonitor.class.getName());
    private final Agent agent;

    public HarakiriMonitor(Agent agent) {
        super("HarakiriMonitor");
        this.agent = agent;
    }

    @Override
    public void run() {
        long maxIdleTimeMs;
        boolean harakiri;
        if (!"aws-ec2".equals(this.agent.cloudProvider)) {
            log.info((Object)"No Harakiri monitor is active: only on aws-ec2 unused machines will be terminated.");
            return;
        }
        log.info((Object)"Harakiri monitor is active");
        do {
            try {
                Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            maxIdleTimeMs = TimeUnit.HOURS.toMillis(2L);
        } while (!(harakiri = System.currentTimeMillis() - maxIdleTimeMs > this.agent.lastUsed));
        log.info((Object)"Trying to commit Harakiri (will only try once)");
        Bash bash = new Bash(new StabilizerProperties());
        try {
            String cmd = String.format("ec2-terminate-instances $(curl -s http://169.254.169.254/latest/meta-data/instance-id) --aws-access-key %s --aws-secret-key %s", this.agent.cloudIdentity, this.agent.cloudCredential);
            log.info((Object)("harakiri command: " + cmd));
            bash.execute(cmd);
        }
        catch (RuntimeException e) {
            log.info((Object)"Failed to execute harikiri");
        }
    }
}

