/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.agent;

import com.hazelcast.stabilizer.worker.commands.Command;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CommandFuture<E>
implements Future<E> {
    private static final Object NO_RESULT = new Object(){

        public String toString() {
            return "NO_RESULT";
        }
    };
    private final Command command;
    private volatile Object result = NO_RESULT;

    public CommandFuture(Command command) {
        this.command = command;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDone() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object result) {
        CommandFuture commandFuture = this;
        synchronized (commandFuture) {
            this.result = result;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get() throws InterruptedException, ExecutionException {
        CommandFuture commandFuture = this;
        synchronized (commandFuture) {
            while (this.result == NO_RESULT) {
                this.wait();
            }
            if (this.result instanceof Throwable) {
                throw new ExecutionException((Throwable)this.result);
            }
            return (E)this.result;
        }
    }

    @Override
    public E get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long remainingTimeoutMs = unit.toMillis(timeout);
        CommandFuture commandFuture = this;
        synchronized (commandFuture) {
            while (true) {
                if (this.result != NO_RESULT) {
                    if (this.result instanceof Throwable) {
                        throw new ExecutionException((Throwable)this.result);
                    }
                    return (E)this.result;
                }
                if (remainingTimeoutMs <= 0L) {
                    throw new TimeoutException("Timeout while executing : " + this.command);
                }
                long startMs = System.currentTimeMillis();
                this.wait(remainingTimeoutMs);
                remainingTimeoutMs -= System.currentTimeMillis() - startMs;
            }
        }
    }
}

