/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.agent;

import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.agent.AgentCli;
import com.hazelcast.stabilizer.agent.HarakiriMonitor;
import com.hazelcast.stabilizer.agent.remoting.AgentMessageProcessor;
import com.hazelcast.stabilizer.agent.remoting.AgentRemoteService;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmFailureMonitor;
import com.hazelcast.stabilizer.agent.workerjvm.WorkerJvmManager;
import com.hazelcast.stabilizer.common.GitInfo;
import com.hazelcast.stabilizer.coordinator.Coordinator;
import com.hazelcast.stabilizer.tests.TestSuite;
import java.io.File;
import java.io.IOException;
import joptsimple.OptionException;
import org.apache.log4j.Logger;

public class Agent {
    private static final Logger log = Logger.getLogger((String)Coordinator.class.getName());
    public static final File STABILIZER_HOME = Utils.getStablizerHome();
    private volatile TestSuite testSuite;
    private final WorkerJvmManager workerJvmManager = new WorkerJvmManager(this);
    private final WorkerJvmFailureMonitor workerJvmFailureMonitor = new WorkerJvmFailureMonitor(this);
    private final HarakiriMonitor harakiriMonitor = new HarakiriMonitor(this);
    public String cloudIdentity;
    public String cloudCredential;
    public String cloudProvider;
    protected volatile long lastUsed = System.currentTimeMillis();

    public void echo(String msg) {
        log.info((Object)msg);
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public void signalUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    public File getTestSuiteDir() {
        TestSuite testSuite = this.testSuite;
        if (testSuite == null) {
            return null;
        }
        return new File(WorkerJvmManager.WORKERS_HOME, testSuite.id);
    }

    public WorkerJvmFailureMonitor getWorkerJvmFailureMonitor() {
        return this.workerJvmFailureMonitor;
    }

    public WorkerJvmManager getWorkerJvmManager() {
        return this.workerJvmManager;
    }

    public void initTestSuite(TestSuite testSuite) throws IOException {
        this.testSuite = testSuite;
        File testSuiteDir = new File(WorkerJvmManager.WORKERS_HOME, testSuite.id);
        Utils.ensureExistingDirectory(testSuiteDir);
        File libDir = new File(testSuiteDir, "lib");
        Utils.ensureExistingDirectory(libDir);
    }

    public void start() throws Exception {
        Utils.ensureExistingDirectory(WorkerJvmManager.WORKERS_HOME);
        this.startRestServer();
        this.workerJvmFailureMonitor.start();
        this.workerJvmManager.start();
        this.harakiriMonitor.start();
        log.info((Object)"Stabilizer Agent is ready for action");
    }

    private void startRestServer() throws IOException {
        AgentMessageProcessor agentMessageProcessor = new AgentMessageProcessor(this.workerJvmManager);
        AgentRemoteService agentRemoteService = new AgentRemoteService(this, agentMessageProcessor);
        agentRemoteService.start();
    }

    public static void main(String[] args) throws Exception {
        log.info((Object)"Stabilizer Agent");
        log.info((Object)String.format("Version: %s, Commit: %s, Build Time: %s", Utils.getVersion(), GitInfo.getCommitIdAbbrev(), GitInfo.getBuildTime()));
        log.info((Object)String.format("STABILIZER_HOME: %s\n", STABILIZER_HOME));
        Agent.logInterestingSystemProperties();
        try {
            Agent agent = new Agent();
            AgentCli.init(agent, args);
            log.info((Object)("CloudIdentity: " + agent.cloudIdentity));
            log.info((Object)("CloudCredential " + agent.cloudCredential));
            log.info((Object)("CloudProvider " + agent.cloudProvider));
            agent.start();
        }
        catch (OptionException e) {
            Agent.exitWithError(log, e.getMessage() + "\nUse --help to get overview of the help options.");
        }
    }

    private static void logInterestingSystemProperties() {
        Agent.logSystemProperty("java.class.path");
        Agent.logSystemProperty("java.home");
        Agent.logSystemProperty("java.vendor");
        Agent.logSystemProperty("java.vendor.url");
        Agent.logSystemProperty("sun.java.command");
        Agent.logSystemProperty("java.version");
        Agent.logSystemProperty("os.arch");
        Agent.logSystemProperty("os.name");
        Agent.logSystemProperty("os.version");
        Agent.logSystemProperty("user.dir");
        Agent.logSystemProperty("user.home");
        Agent.logSystemProperty("user.name");
        Agent.logSystemProperty("STABILIZER_HOME");
    }

    private static void logSystemProperty(String name) {
        log.info((Object)String.format("%s=%s", name, System.getProperty(name)));
    }

    public static void exitWithError(Logger logger, String msg) {
        logger.fatal((Object)msg);
        System.exit(1);
    }
}

