/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.LockSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.lang3.text.StrSubstitutor;

public final class Utils {
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static final String USER_HOME = System.getProperty("user.home");
    private static final ILogger log = Logger.getLogger(Utils.class);
    private static final String DEFAULT_DELIMITER = ", ";
    private static volatile String hostAddress;
    private static final String EXCEPTION_SEPARATOR = "------ End remote and begin local stack-trace ------";

    public static void fixRemoteStackTrace(Throwable remoteCause, StackTraceElement[] localSideStackTrace) {
        StackTraceElement[] remoteStackTrace = remoteCause.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[localSideStackTrace.length + remoteStackTrace.length];
        System.arraycopy(remoteStackTrace, 0, newStackTrace, 0, remoteStackTrace.length);
        newStackTrace[remoteStackTrace.length] = new StackTraceElement(EXCEPTION_SEPARATOR, "", null, -1);
        System.arraycopy(localSideStackTrace, 1, newStackTrace, remoteStackTrace.length + 1, localSideStackTrace.length - 1);
        remoteCause.setStackTrace(newStackTrace);
    }

    public static File newFile(String path) {
        if ((path = path.trim()).equals("~")) {
            path = USER_HOME;
        } else if (path.startsWith("~" + File.separator)) {
            path = USER_HOME + path.substring(1);
        }
        StrSubstitutor substitutor = new StrSubstitutor();
        path = substitutor.replace(path);
        return new File(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(String url) throws IOException {
        String string;
        URL website = new URL(url);
        URLConnection connection = website.openConnection();
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            string = response.toString();
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(in);
            throw throwable;
        }
        Utils.closeQuietly((Closeable)in);
        return string;
    }

    public static File newFile(File file, String ... items) {
        for (int k = 0; k < items.length; ++k) {
            file = new File(file, items[k]);
        }
        return file;
    }

    public static File newFile(String ... items) {
        File file = Utils.newFile(items[0]);
        for (int k = 1; k < items.length; ++k) {
            file = new File(file, items[k]);
        }
        return file;
    }

    public static String getHostAddress() {
        if (hostAddress != null) {
            return hostAddress;
        }
        Class<Utils> clazz = Utils.class;
        synchronized (Utils.class) {
            try {
                if (hostAddress != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return hostAddress;
                }
                Socket s = new Socket("google.com", 80);
                hostAddress = s.getLocalAddress().getHostAddress();
                s.close();
                // ** MonitorExit[var0] (shouldn't be in output)
                return hostAddress;
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(Object o, File file) {
        File tmpFile = new File(file.getParent(), file.getName() + ".tmp");
        try {
            FileOutputStream fous = new FileOutputStream(tmpFile);
            try {
                ObjectOutputStream output = new ObjectOutputStream(fous);
                output.writeObject(o);
            }
            finally {
                Utils.closeQuietly((Closeable)fous);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!tmpFile.renameTo(file)) {
            throw new RuntimeException(String.format("Could not rename [%s] to [%s]", tmpFile.getAbsolutePath(), file.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E> E readObject(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                ObjectInputStream in = new ObjectInputStream(fis);
                Object object = in.readObject();
                return (E)object;
            }
            finally {
                Utils.closeQuietly((Closeable)fis);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeText(String text, File file) {
        if (text == null) {
            throw new NullPointerException("text can't be null");
        }
        if (file == null) {
            throw new NullPointerException("file can't be null");
        }
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
                writer.write(text);
                ((Writer)writer).close();
            }
            finally {
                Utils.closeQuietly((Closeable)stream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendText(String text, String file) {
        Utils.appendText(text, new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendText(String text, File file) {
        if (text == null) {
            throw new NullPointerException("text can't be null");
        }
        if (file == null) {
            throw new NullPointerException("file can't be null");
        }
        try {
            FileOutputStream stream = new FileOutputStream(file, true);
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
                writer.write(text);
                ((Writer)writer).close();
            }
            finally {
                Utils.closeQuietly((Closeable)stream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fileAsText(String filePath) {
        return Utils.fileAsText(new File(filePath));
    }

    public static String[] fileAsLines(File file) {
        return Utils.fileAsText(file).split("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileAsText(File file) {
        String string;
        FileInputStream stream = new FileInputStream(file);
        try {
            int read;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                Utils.closeQuietly((Closeable)stream);
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Utils.closeQuietly((Closeable)stream);
        return string;
    }

    public static void delete(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                Utils.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public static void ensureExistingDirectory(File dir) {
        if (dir.isDirectory()) {
            return;
        }
        if (dir.isFile()) {
            throw new IllegalArgumentException(String.format("File [%s] is not a directory", dir.getAbsolutePath()));
        }
        if (!dir.mkdirs()) {
            throw new RuntimeException("Could not create directory: " + dir.getAbsolutePath());
        }
    }

    public static String getVersion() {
        return Utils.class.getPackage().getImplementationVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(List<File> roots) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedList<File> queue = new LinkedList<File>();
        ZipOutputStream zout = new ZipOutputStream(out);
        HashSet<String> names = new HashSet<String>();
        try {
            for (File root : roots) {
                URI base = root.isDirectory() ? root.toURI() : root.getParentFile().toURI();
                queue.push(root);
                while (!queue.isEmpty()) {
                    String name;
                    File file = (File)queue.pop();
                    if (file.getName().equals(".DS_Store")) continue;
                    if (file.isDirectory()) {
                        name = base.relativize(file.toURI()).getPath();
                        String string = name = name.endsWith("/") ? name : name + "/";
                        if (names.add(name)) {
                            zout.putNextEntry(new ZipEntry(name));
                        }
                        for (File kid : file.listFiles()) {
                            queue.push(kid);
                        }
                        continue;
                    }
                    name = base.relativize(file.toURI()).getPath();
                    zout.putNextEntry(new ZipEntry(name));
                    Utils.copy(file, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
        }
        finally {
            zout.close();
        }
        return out.toByteArray();
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File file, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Utils.copy(in, out);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static String throwableToString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(byte[] content, File destinationDir) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(content));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            String fileName = zipEntry.getName();
            File file = new File(destinationDir + File.separator + fileName);
            if (zipEntry.isDirectory()) {
                file.mkdirs();
            } else {
                file.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(file);
                try {
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                finally {
                    Utils.closeQuietly((Closeable)fos);
                }
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    public static File getStablizerHome() {
        String home = System.getenv("STABILIZER_HOME");
        if (home == null) {
            return new File(System.getProperty("user.dir"));
        }
        return new File(home);
    }

    public static void closeQuietly(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        for (Closeable c : closeables) {
            Utils.closeQuietly(c);
        }
    }

    public static void closeQuietly(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void sleepSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sleepMillis(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sleepNanos(long nanos) {
        if (nanos <= 0L) {
            return;
        }
        LockSupport.parkNanos(nanos);
    }

    public static void exitWithError(ILogger logger, String msg) {
        logger.severe(msg);
        System.exit(1);
    }

    private Utils() {
    }

    public static String secondsToHuman(long seconds) {
        long time = seconds;
        long s = time % 60L;
        long m = (time /= 60L) % 60L;
        long h = (time /= 60L) % 24L;
        long days = time /= 24L;
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("%02d", days)).append("d ").append(String.format("%02d", h)).append("h ").append(String.format("%02d", m)).append("m ").append(String.format("%02d", s)).append("s");
        return sb.toString();
    }

    public static Properties loadProperties(File file) {
        FileInputStream in;
        Properties properties = new Properties();
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            properties.load(in);
            Properties e = properties;
            return e;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to load testsuite property file [%s]", file.getAbsolutePath()), e);
        }
        finally {
            Utils.closeQuietly((Closeable)in);
        }
    }

    public static String join(Iterable<?> collection) {
        return Utils.join(collection, DEFAULT_DELIMITER);
    }

    public static String join(Iterable<?> collection, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            builder.append(o);
            if (!iterator.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static File getFile(OptionSpec<String> spec, OptionSet options, String desc) {
        File file = Utils.newFile((String)options.valueOf(spec));
        if (!file.exists()) {
            Utils.exitWithError(log, String.format("%s [%s] does not exist\n", desc, file));
        }
        return file;
    }

    public static List<File> getFilesFromClassPath(String classpath) throws IOException {
        if (classpath == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<File> files = new LinkedList<File>();
        for (String filePath : classpath.split(";")) {
            File file = new File(filePath);
            if (file.getName().contains("*")) {
                File parent = file.getParentFile();
                if (!parent.isDirectory()) {
                    throw new IOException(String.format("Cannot convert classpath to java.io.File. [%s] is not a directory", parent));
                }
                String regex = file.getName().replace("*", "(.*)");
                for (File child : parent.listFiles()) {
                    if (!child.getName().matches(regex)) continue;
                    files.add(child);
                }
                continue;
            }
            if (file.exists()) {
                files.add(file);
                continue;
            }
            Utils.exitWithError(log, String.format("Cannot convert classpath to java.io.File. [%s] doesn't exist", filePath));
        }
        return files;
    }
}

