/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer;

import com.hazelcast.stabilizer.Utils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import sun.management.VMManagement;

public class NativeUtils {
    private static final Logger log = Logger.getLogger(NativeUtils.class);

    private NativeUtils() {
    }

    public static Integer getPIDorNull() {
        Integer pidFromManagementBean = NativeUtils.getPidFromManagementBean();
        return pidFromManagementBean != null ? pidFromManagementBean : NativeUtils.getPidViaReflection();
    }

    public static void kill(int pid) {
        log.info((Object)("Sending -9 signal to PID " + pid));
        try {
            Runtime.getRuntime().exec("/bin/kill -9 " + pid + " >/dev/null");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void execute(String command) {
        StringBuffer sb = new StringBuffer();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing bash command: " + command));
        }
        try {
            ProcessBuilder pb = new ProcessBuilder("bash", "-c", command);
            pb = pb.redirectErrorStream(true);
            Process shell = pb.start();
            new BashStreamGobbler(shell.getInputStream(), sb).start();
            int shellExitStatus = shell.waitFor();
            if (shellExitStatus != 0) {
                log.error((Object)String.format("Failed to execute [%s]", command));
                log.error((Object)sb.toString());
                System.exit(1);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Bash output: \n" + sb));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Integer getPidFromManagementBean() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int indexOf = name.indexOf("@");
        if (indexOf == -1) {
            return null;
        }
        String pidString = name.substring(0, indexOf);
        try {
            return Integer.parseInt(pidString);
        }
        catch (NumberFormatException e) {
            log.warn((Object)e);
            return null;
        }
    }

    private static Integer getPidViaReflection() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            Field jvm = runtime.getClass().getDeclaredField("jvm");
            jvm.setAccessible(true);
            VMManagement mgmt = (VMManagement)jvm.get(runtime);
            Method pid_method = mgmt.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            pid_method.setAccessible(true);
            return (Integer)pid_method.invoke((Object)mgmt, new Object[0]);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)e);
            return null;
        }
        catch (InvocationTargetException e) {
            log.warn((Object)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)e);
            return null;
        }
        catch (NoSuchFieldException e) {
            log.warn((Object)e);
            return null;
        }
    }

    public static class BashStreamGobbler
    extends Thread {
        private final BufferedReader reader;
        private final StringBuffer stringBuffer;

        public BashStreamGobbler(InputStream in, StringBuffer stringBuffer) {
            this.reader = new BufferedReader(new InputStreamReader(in));
            this.stringBuffer = stringBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    this.stringBuffer.append(line).append("\n");
                }
            }
            catch (IOException iOException) {
            }
            finally {
                Utils.closeQuietly((Closeable)this.reader);
            }
        }
    }
}

