/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.config;

import com.google.common.base.Function;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.config.BaseEC2HttpApiModule;
import org.jclouds.ec2.features.AMIApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.features.SecurityGroupApi;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.rest.ConfiguresHttpApi;

@ConfiguresHttpApi
public class AWSEC2HttpApiModule
extends BaseEC2HttpApiModule<AWSEC2Api> {
    public AWSEC2HttpApiModule() {
        super(AWSEC2Api.class);
    }

    @Singleton
    @Provides
    EC2Api provide(AWSEC2Api in) {
        return in;
    }

    @Singleton
    @Provides
    InstanceApi getInstanceApi(AWSEC2Api in) {
        return (InstanceApi)in.getInstanceApi().get();
    }

    @Singleton
    @Provides
    SecurityGroupApi getSecurityGroupApi(AWSEC2Api in) {
        return (SecurityGroupApi)in.getSecurityGroupApi().get();
    }

    @Singleton
    @Provides
    AMIApi getAMIApi(AWSEC2Api in) {
        return (AMIApi)in.getAMIApi().get();
    }

    protected void configure() {
        this.bind(RunInstancesOptions.class).to(AWSRunInstancesOptions.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<SpotInstanceRequest, AWSRunningInstance>>(){}).to(SpotInstanceRequestToAWSRunningInstance.class);
        super.configure();
    }
}

