/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import com.google.common.base.Joiner;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.bytecode.MethodInfo;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import javax.annotation.Nullable;
import org.reflections.ReflectionsException;
import org.reflections.scanners.AbstractScanner;

public class MemberUsageScanner
extends AbstractScanner {
    private static final ClassPool CLASS_POOL;
    @Nullable
    public static Method removeCached;

    public void scan(Object cls) {
        try {
            CtClass ctClass = CLASS_POOL.get(this.getMetadataAdapter().getClassName(cls));
            for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
                this.scanMember((CtBehavior)ctConstructor);
            }
            for (CtConstructor ctConstructor : ctClass.getDeclaredMethods()) {
                this.scanMember((CtBehavior)ctConstructor);
            }
            if (removeCached != null) {
                removeCached.invoke((Object)ClassPool.getDefault(), ctClass.getName());
            }
        }
        catch (Exception e) {
            throw new ReflectionsException("Could not scan method usage for " + this.getMetadataAdapter().getClassName(cls), e);
        }
    }

    void scanMember(CtBehavior member) throws CannotCompileException {
        final String key = member.getDeclaringClass().getName() + "." + member.getMethodInfo().getName() + "(" + this.parameterNames(member.getMethodInfo()) + ")";
        member.instrument(new ExprEditor(){

            public void edit(NewExpr e) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(e.getConstructor().getDeclaringClass().getName() + "." + "<init>" + "(" + MemberUsageScanner.this.parameterNames(e.getConstructor().getMethodInfo()) + ")", e.getLineNumber(), key);
                }
                catch (NotFoundException e1) {
                    throw new ReflectionsException("Could not find new instance usage in " + key, e1);
                }
            }

            public void edit(MethodCall m) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(m.getMethod().getDeclaringClass().getName() + "." + m.getMethodName() + "(" + MemberUsageScanner.this.parameterNames(m.getMethod().getMethodInfo()) + ")", m.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + m.getClassName() + " in " + key, e);
                }
            }

            public void edit(ConstructorCall c) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(c.getConstructor().getDeclaringClass().getName() + "." + "<init>" + "(" + MemberUsageScanner.this.parameterNames(c.getConstructor().getMethodInfo()) + ")", c.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + c.getClassName() + " in " + key, e);
                }
            }

            public void edit(FieldAccess f) throws CannotCompileException {
                try {
                    MemberUsageScanner.this.put(f.getField().getDeclaringClass().getName() + "." + f.getFieldName(), f.getLineNumber(), key);
                }
                catch (NotFoundException e) {
                    throw new ReflectionsException("Could not find member " + f.getFieldName() + " in " + key, e);
                }
            }
        });
    }

    private void put(String key, int lineNumber, String value) {
        if (this.acceptResult(key)) {
            this.getStore().put((Object)key, (Object)(value + " #" + lineNumber));
        }
    }

    String parameterNames(MethodInfo info) {
        return Joiner.on((String)", ").join(this.getMetadataAdapter().getParameterNames(info));
    }

    static {
        try {
            CLASS_POOL = ClassPool.getDefault();
            removeCached = ClassPool.class.getDeclaredMethod("removeCached", String.class);
            removeCached.setAccessible(true);
        }
        catch (Throwable e) {
            throw new ReflectionsException("Can't use MemberUsageScanner", e);
        }
    }
}

