/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue;

import com.hazelcast.queue.CheckAndEvictOperation;
import com.hazelcast.queue.QueueService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.Collection;

public class QueueEvictionProcessor
implements ScheduledEntryProcessor<String, Void> {
    final NodeEngine nodeEngine;
    final QueueService service;

    public QueueEvictionProcessor(NodeEngine nodeEngine, QueueService service) {
        this.nodeEngine = nodeEngine;
        this.service = service;
    }

    @Override
    public void process(EntryTaskScheduler<String, Void> scheduler, Collection<ScheduledEntry<String, Void>> entries) {
        if (entries.isEmpty()) {
            return;
        }
        for (ScheduledEntry<String, Void> entry : entries) {
            String name = entry.getKey();
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(this.nodeEngine.toData(name));
            CheckAndEvictOperation op = new CheckAndEvictOperation(entry.getKey());
            this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:queueService", op, partitionId).getSafely();
        }
    }
}

