/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.query.impl.AttributeType;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.QueryException;
import com.hazelcast.query.impl.QueryableEntry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReflectionHelper {
    private static final ClassLoader THIS_CL = ReflectionHelper.class.getClassLoader();
    private static final ConcurrentMap<String, Getter> getterCache = new ConcurrentHashMap<String, Getter>(1000);

    private ReflectionHelper() {
    }

    public static AttributeType getAttributeType(Class klass) {
        if (klass == String.class) {
            return AttributeType.STRING;
        }
        if (klass == Integer.TYPE || klass == Integer.class) {
            return AttributeType.INTEGER;
        }
        if (klass == Long.TYPE || klass == Long.class) {
            return AttributeType.LONG;
        }
        if (klass == Boolean.TYPE || klass == Boolean.class) {
            return AttributeType.BOOLEAN;
        }
        if (klass == Double.TYPE || klass == Double.class) {
            return AttributeType.DOUBLE;
        }
        if (klass == BigDecimal.class) {
            return AttributeType.BIG_DECIMAL;
        }
        if (klass == BigInteger.class) {
            return AttributeType.BIG_INTEGER;
        }
        if (klass == Float.TYPE || klass == Float.class) {
            return AttributeType.FLOAT;
        }
        if (klass == Byte.TYPE || klass == Byte.class) {
            return AttributeType.BYTE;
        }
        if (klass == Character.TYPE || klass == Character.class) {
            return AttributeType.CHAR;
        }
        if (klass == Timestamp.class) {
            return AttributeType.SQL_TIMESTAMP;
        }
        if (klass == Date.class) {
            return AttributeType.SQL_DATE;
        }
        if (klass == java.util.Date.class) {
            return AttributeType.DATE;
        }
        if (klass.isEnum()) {
            return AttributeType.ENUM;
        }
        return null;
    }

    public static void reset() {
        getterCache.clear();
    }

    public static AttributeType getAttributeType(QueryableEntry entry, String attribute) {
        return ReflectionHelper.getAttributeType(ReflectionHelper.createGetter(entry, attribute).getReturnType());
    }

    private static Getter createGetter(QueryableEntry entry, String attribute) {
        Class<?> clazz;
        String cacheKey;
        Getter getter;
        Object obj;
        if (attribute.startsWith("__key")) {
            obj = entry.getKey();
            if (attribute.length() > "__key".length()) {
                attribute = attribute.substring("__key".length() + 1);
            }
        } else {
            obj = entry.getValue();
        }
        if ((getter = (Getter)getterCache.get(cacheKey = (clazz = obj.getClass()).getName() + ":" + attribute)) != null) {
            return getter;
        }
        try {
            Getter foundGetter;
            ThisGetter parent = null;
            ArrayList<String> possibleMethodNames = new ArrayList<String>(3);
            for (String name : attribute.split("\\.")) {
                Getter localGetter = null;
                possibleMethodNames.clear();
                possibleMethodNames.add(name);
                String camelName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                possibleMethodNames.add("get" + camelName);
                possibleMethodNames.add("is" + camelName);
                if (name.equals("this")) {
                    localGetter = new ThisGetter(parent, obj);
                } else {
                    for (String methodName : possibleMethodNames) {
                        try {
                            Method method = clazz.getMethod(methodName, new Class[0]);
                            method.setAccessible(true);
                            localGetter = new MethodGetter(parent, method);
                            clazz = method.getReturnType();
                            break;
                        }
                        catch (NoSuchMethodException ignored) {
                        }
                    }
                    if (localGetter == null) {
                        try {
                            Field field = clazz.getField(name);
                            localGetter = new FieldGetter(parent, field);
                            clazz = field.getType();
                        }
                        catch (NoSuchFieldException ignored) {
                            // empty catch block
                        }
                    }
                    if (localGetter == null) {
                        Class<?> c = clazz;
                        while (!Object.class.equals(c)) {
                            try {
                                Field field = c.getDeclaredField(name);
                                field.setAccessible(true);
                                localGetter = new FieldGetter(parent, field);
                                clazz = field.getType();
                                break;
                            }
                            catch (NoSuchFieldException ignored) {
                                c = c.getSuperclass();
                            }
                        }
                    }
                }
                if (localGetter == null) {
                    throw new IllegalArgumentException("There is no suitable accessor for '" + name + "' on class '" + clazz + "'");
                }
                parent = localGetter;
            }
            getter = parent;
            if (getter.isCacheable() && (foundGetter = getterCache.putIfAbsent(cacheKey, getter)) != null) {
                getter = foundGetter;
            }
            return getter;
        }
        catch (Throwable e) {
            throw new QueryException(e);
        }
    }

    public static Comparable extractValue(QueryEntry queryEntry, String attributeName, Object object) throws Exception {
        return (Comparable)ReflectionHelper.createGetter(queryEntry, attributeName).getValue(object);
    }

    static class ThisGetter
    extends Getter {
        final Object object;

        public ThisGetter(Getter parent, Object object) {
            super(parent);
            this.object = object;
        }

        @Override
        Object getValue(Object obj) throws Exception {
            return obj;
        }

        @Override
        Class getReturnType() {
            return this.object.getClass();
        }

        @Override
        boolean isCacheable() {
            return false;
        }
    }

    static class FieldGetter
    extends Getter {
        final Field field;

        FieldGetter(Getter parent, Field field) {
            super(parent);
            this.field = field;
        }

        @Override
        Object getValue(Object obj) throws Exception {
            obj = this.parent != null ? this.parent.getValue(obj) : obj;
            return obj != null ? this.field.get(obj) : null;
        }

        @Override
        Class getReturnType() {
            return this.field.getType();
        }

        @Override
        boolean isCacheable() {
            return THIS_CL.equals(this.field.getDeclaringClass().getClassLoader());
        }

        public String toString() {
            return "FieldGetter [parent=" + this.parent + ", field=" + this.field + "]";
        }
    }

    static class MethodGetter
    extends Getter {
        final Method method;

        MethodGetter(Getter parent, Method method) {
            super(parent);
            this.method = method;
        }

        @Override
        Object getValue(Object obj) throws Exception {
            obj = this.parent != null ? this.parent.getValue(obj) : obj;
            return obj != null ? this.method.invoke(obj, new Object[0]) : null;
        }

        @Override
        Class getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        boolean isCacheable() {
            return THIS_CL.equals(this.method.getDeclaringClass().getClassLoader());
        }

        public String toString() {
            return "MethodGetter [parent=" + this.parent + ", method=" + this.method.getName() + "]";
        }
    }

    private static abstract class Getter {
        protected final Getter parent;

        public Getter(Getter parent) {
            this.parent = parent;
        }

        abstract Object getValue(Object var1) throws Exception;

        abstract Class getReturnType();

        abstract boolean isCacheable();
    }
}

