/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Operation;

public class ZoneOperationDonePredicate
implements Predicate<AtomicReference<Operation>> {
    private final GoogleComputeEngineApi api;
    private final Supplier<String> project;
    private final Supplier<Map<URI, ? extends Location>> zones;

    @Inject
    ZoneOperationDonePredicate(GoogleComputeEngineApi api, @UserProject Supplier<String> project, @Memoized Supplier<Map<URI, ? extends Location>> zones) {
        this.api = api;
        this.project = project;
        this.zones = zones;
    }

    public boolean apply(AtomicReference<Operation> input) {
        Preconditions.checkNotNull(input, (Object)"input");
        Operation current = this.api.getZoneOperationApiForProject((String)this.project.get()).getInZone(((Location)((Map)this.zones.get()).get(input.get().getZone().get())).getId(), input.get().getName());
        switch (current.getStatus()) {
            case DONE: {
                input.set(current);
                return true;
            }
        }
        return false;
    }
}

