/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;

public class RouteOptions {
    private String name;
    private URI network;
    private String destRange;
    private URI nextHopInstance;
    private String nextHopIp;
    private URI nextHopNetwork;
    private URI nextHopGateway;
    private String description;
    private Integer priority;
    private ImmutableSet.Builder<String> tags = ImmutableSet.builder();

    public String getName() {
        return this.name;
    }

    public RouteOptions name(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public RouteOptions description(String description) {
        this.description = description;
        return this;
    }

    public String getDestRange() {
        return this.destRange;
    }

    public RouteOptions destRange(String destRange) {
        this.destRange = destRange;
        return this;
    }

    public String getNextHopIp() {
        return this.nextHopIp;
    }

    public RouteOptions nextHopIp(String nextHopIp) {
        this.nextHopIp = nextHopIp;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public RouteOptions priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public RouteOptions network(URI network) {
        this.network = network;
        return this;
    }

    public URI getNetwork() {
        return this.network;
    }

    public RouteOptions nextHopInstance(URI nextHopInstance) {
        this.nextHopInstance = nextHopInstance;
        return this;
    }

    public URI getNextHopInstance() {
        return this.nextHopInstance;
    }

    public RouteOptions nextHopNetwork(URI nextHopNetwork) {
        this.nextHopNetwork = nextHopNetwork;
        return this;
    }

    public URI getNextHopNetwork() {
        return this.nextHopNetwork;
    }

    public RouteOptions nextHopGateway(URI nextHopGateway) {
        this.nextHopGateway = nextHopGateway;
        return this;
    }

    public URI getNextHopGateway() {
        return this.nextHopGateway;
    }

    public Set<String> getTags() {
        return this.tags.build();
    }

    public RouteOptions addTag(String tag) {
        this.tags.add((Object)tag);
        return this;
    }

    public RouteOptions tags(Set<String> tags) {
        this.tags = ImmutableSet.builder();
        this.tags.addAll(tags);
        return this;
    }
}

