/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.functions.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Snapshot;
import org.jclouds.googlecomputeengine.functions.internal.BaseToPagedIterable;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;

@Singleton
public class ParseSnapshots
extends ParseJson<ListPage<Snapshot>> {
    @Inject
    public ParseSnapshots(Json json) {
        super(json, (TypeLiteral)new TypeLiteral<ListPage<Snapshot>>(){});
    }

    public static class ToPagedIterable
    extends BaseToPagedIterable<Snapshot, ToPagedIterable> {
        private final GoogleComputeEngineApi api;

        @Inject
        protected ToPagedIterable(GoogleComputeEngineApi api) {
            this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        @Override
        protected Function<Object, IterableWithMarker<Snapshot>> fetchNextPage(final String projectName, final ListOptions options) {
            return new Function<Object, IterableWithMarker<Snapshot>>(){

                public IterableWithMarker<Snapshot> apply(Object input) {
                    return ToPagedIterable.this.api.getSnapshotApiForProject(projectName).listAtMarker(input.toString(), options);
                }
            };
        }
    }
}

