/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.internal.NetworkAndAddressRange;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

@Singleton
public class CreateNetworkIfNeeded
implements Function<NetworkAndAddressRange, Network> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final GoogleComputeEngineApi api;
    protected final Supplier<String> userProject;
    private final Predicate<AtomicReference<Operation>> operationDonePredicate;
    private final long operationCompleteCheckInterval;
    private final long operationCompleteCheckTimeout;

    @Inject
    public CreateNetworkIfNeeded(GoogleComputeEngineApi api, @UserProject Supplier<String> userProject, @Named(value="global") Predicate<AtomicReference<Operation>> operationDonePredicate, @Named(value="jclouds.google-compute-engine.operation-complete-interval") Long operationCompleteCheckInterval, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") Long operationCompleteCheckTimeout) {
        this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.userProject = (Supplier)Preconditions.checkNotNull(userProject, (Object)"userProject");
        this.operationCompleteCheckInterval = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckInterval, (Object)"operation completed check interval");
        this.operationCompleteCheckTimeout = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckTimeout, (Object)"operation completed check timeout");
        this.operationDonePredicate = (Predicate)Preconditions.checkNotNull(operationDonePredicate, (Object)"operationDonePredicate");
    }

    public Network apply(NetworkAndAddressRange input) {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        Network nw = this.api.getNetworkApiForProject((String)this.userProject.get()).get(input.getName());
        if (nw != null) {
            return nw;
        }
        if (input.getGateway().isPresent()) {
            AtomicReference operation = Atomics.newReference((Object)this.api.getNetworkApiForProject((String)this.userProject.get()).createInIPv4RangeWithGateway(input.getName(), input.getIpV4Range(), (String)input.getGateway().get()));
            Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)operation);
            Preconditions.checkState((!((Operation)operation.get()).getHttpError().isPresent() ? 1 : 0) != 0, (Object)("Could not create network, operation failed" + operation));
        } else {
            AtomicReference operation = Atomics.newReference((Object)this.api.getNetworkApiForProject((String)this.userProject.get()).createInIPv4Range(input.getName(), input.getIpV4Range()));
            Predicates2.retry(this.operationDonePredicate, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)operation);
            Preconditions.checkState((!((Operation)operation.get()).getHttpError().isPresent() ? 1 : 0) != 0, (Object)("Could not create network, operation failed" + operation));
        }
        return (Network)Preconditions.checkNotNull((Object)this.api.getNetworkApiForProject((String)this.userProject.get()).get(input.getName()), (String)"no network with name %s was found", (Object[])new Object[]{input.getName()});
    }
}

