/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import java.net.URI;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Route;
import org.jclouds.googlecomputeengine.functions.internal.ParseRoutes;
import org.jclouds.googlecomputeengine.handlers.RouteBinder;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.googlecomputeengine.options.RouteOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticator;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticator.class})
@Consumes(value={"application/json"})
public interface RouteApi {
    @Named(value="Routes:get")
    @GET
    @Path(value="/global/routes/{route}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Route get(@PathParam(value="route") String var1);

    @Named(value="Routes:list")
    @GET
    @Path(value="/global/routes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseRoutes.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Route> listFirstPage();

    @Named(value="Routes:list")
    @GET
    @Path(value="/global/routes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseRoutes.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Route> listAtMarker(String var1);

    @Named(value="Routes:list")
    @GET
    @Path(value="/global/routes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseRoutes.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Route> listAtMarker(String var1, ListOptions var2);

    @Named(value="Routes:list")
    @GET
    @Path(value="/global/routes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseRoutes.class)
    @Transform(value=ParseRoutes.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Route> list();

    @Named(value="Routes:list")
    @GET
    @Path(value="/global/routes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseRoutes.class)
    @Transform(value=ParseRoutes.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Route> list(ListOptions var1);

    @Named(value="Routes:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/global/routes/{route}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="route") String var1);

    @Named(value="Routes:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/global/routes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=RouteBinder.class)
    public Operation createInNetwork(@PayloadParam(value="name") String var1, @PayloadParam(value="network") URI var2, @PayloadParam(value="options") RouteOptions var3);
}

