/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Project;
import org.jclouds.googlecomputeengine.handlers.MetadataBinder;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticator;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticator.class})
public interface ProjectApi {
    @Named(value="Projects:get")
    @GET
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/projects/{project}")
    public Project get(@PathParam(value="project") String var1);

    @Named(value="Projects:setCommonInstanceMetadata")
    @POST
    @Path(value="/projects/{project}/setCommonInstanceMetadata")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @MapBinder(value=MetadataBinder.class)
    public Operation setCommonInstanceMetadata(@PathParam(value="project") String var1, @PayloadParam(value="items") Map<String, String> var2, @PayloadParam(value="fingerprint") String var3);
}

