/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.functions.internal.ParseMachineTypes;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticator;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticator.class})
@Consumes(value={"application/json"})
public interface MachineTypeApi {
    @Named(value="MachineTypes:get")
    @GET
    @Path(value="/zones/{zone}/machineTypes/{machineType}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public MachineType getInZone(@PathParam(value="zone") String var1, @PathParam(value="machineType") String var2);

    @Named(value="MachineTypes:list")
    @GET
    @Path(value="/zones/{zone}/machineTypes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseMachineTypes.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<MachineType> listFirstPageInZone(@PathParam(value="zone") String var1);

    @Named(value="MachineTypes:list")
    @GET
    @Path(value="/zones/{zone}/machineTypes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseMachineTypes.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<MachineType> listAtMarkerInZone(@PathParam(value="zone") String var1, @QueryParam(value="pageToken") @Nullable String var2);

    @Named(value="MachineTypes:list")
    @GET
    @Path(value="/zones/{zone}/machineTypes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseMachineTypes.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<MachineType> listAtMarkerInZone(@PathParam(value="zone") String var1, @QueryParam(value="pageToken") @Nullable String var2, ListOptions var3);

    @Named(value="MachineTypes:list")
    @GET
    @Path(value="/zones/{zone}/machineTypes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseMachineTypes.class)
    @Transform(value=ParseMachineTypes.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<MachineType> listInZone(@PathParam(value="zone") String var1);

    @Named(value="MachineTypes:list")
    @GET
    @Path(value="/zones/{zone}/machineTypes")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseMachineTypes.class)
    @Transform(value=ParseMachineTypes.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<MachineType> listInZone(@PathParam(value="zone") String var1, ListOptions var2);
}

