/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.InstanceTemplate;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.functions.internal.ParseInstances;
import org.jclouds.googlecomputeengine.handlers.InstanceBinder;
import org.jclouds.googlecomputeengine.handlers.MetadataBinder;
import org.jclouds.googlecomputeengine.options.AttachDiskOptions;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticator;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticator.class})
public interface InstanceApi {
    @Named(value="Instances:get")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances/{instance}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Instance getInZone(@PathParam(value="zone") String var1, @PathParam(value="instance") String var2);

    @Named(value="Instances:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/zones/{zone}/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=InstanceBinder.class)
    public Operation createInZone(@PayloadParam(value="name") String var1, @PathParam(value="zone") String var2, @PayloadParam(value="template") InstanceTemplate var3);

    @Named(value="Instances:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances/{instance}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation deleteInZone(@PathParam(value="zone") String var1, @PathParam(value="instance") String var2);

    @Named(value="Instances:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseInstances.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Instance> listFirstPageInZone(@PathParam(value="zone") String var1);

    @Named(value="Instances:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseInstances.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Instance> listAtMarkerInZone(@PathParam(value="zone") String var1, @Nullable String var2, ListOptions var3);

    @Named(value="Instances:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseInstances.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Instance> listAtMarkerInZone(@PathParam(value="zone") String var1, @Nullable String var2);

    @Named(value="Instances:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseInstances.class)
    @Transform(value=ParseInstances.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Instance> listInZone(@PathParam(value="zone") String var1);

    @Named(value="Instances:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseInstances.class)
    @Transform(value=ParseInstances.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Instance> listInZone(@PathParam(value="zone") String var1, ListOptions var2);

    @Named(value="Instances:addAccessConfig")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/zones/{zone}/instances/{instance}/addAccessConfig")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    public Operation addAccessConfigToNicInZone(@PathParam(value="zone") String var1, @PathParam(value="instance") String var2, @BinderParam(value=BindToJsonPayload.class) Instance.NetworkInterface.AccessConfig var3, @QueryParam(value="network_interface") String var4);

    @Named(value="Instances:deleteAccessConfig")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances/{instance}/deleteAccessConfig")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    public Operation deleteAccessConfigFromNicInZone(@PathParam(value="zone") String var1, @PathParam(value="instance") String var2, @QueryParam(value="access_config") String var3, @QueryParam(value="network_interface") String var4);

    @Named(value="Instances:serialPort")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances/{instance}/serialPort")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    public Instance.SerialPortOutput getSerialPortOutputInZone(@PathParam(value="zone") String var1, @PathParam(value="instance") String var2);

    @Named(value="Instances:reset")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances/{instance}/reset")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation resetInZone(@PathParam(value="zone") String var1, @PathParam(value="instance") String var2);

    @Named(value="Instances:attachDisk")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/zones/{zone}/instances/{instance}/attachDisk")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation attachDiskInZone(@PathParam(value="zone") String var1, @PathParam(value="instance") String var2, @BinderParam(value=BindToJsonPayload.class) AttachDiskOptions var3);

    @Named(value="Instances:detachDisk")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/zones/{zone}/instances/{instance}/detachDisk")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation detachDiskInZone(@PathParam(value="zone") String var1, @PathParam(value="instance") String var2, @QueryParam(value="deviceName") String var3);

    @Named(value="Instances:setMetadata")
    @POST
    @Path(value="/zones/{zone}/instances/{instance}/setMetadata")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @MapBinder(value=MetadataBinder.class)
    @Nullable
    public Operation setMetadataInZone(@PathParam(value="zone") String var1, @PathParam(value="instance") String var2, @PayloadParam(value="items") Map<String, String> var3, @PayloadParam(value="fingerprint") String var4);

    @Named(value="Instances:setTags")
    @POST
    @Path(value="/zones/{zone}/instances/{instance}/setTags")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @MapBinder(value=BindToJsonPayload.class)
    @Nullable
    public Operation setTagsInZone(@PathParam(value="zone") String var1, @PathParam(value="instance") String var2, @PayloadParam(value="items") Set<String> var3, @PayloadParam(value="fingerprint") String var4);
}

