/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.functions.internal.ParseImages;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticator;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticator.class})
public interface ImageApi {
    @Named(value="Images:get")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/images/{image}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Image get(@PathParam(value="image") String var1);

    @Named(value="Images:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/global/images/{image}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="image") String var1);

    @Named(value="Images:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/images")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseImages.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Image> listFirstPage();

    @Named(value="Images:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/images")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseImages.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Image> listAtMarker(@QueryParam(value="pageToken") @Nullable String var1);

    @Named(value="Images:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/images")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseImages.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Image> listAtMarker(@QueryParam(value="pageToken") @Nullable String var1, ListOptions var2);

    @Named(value="Images:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/images")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseImages.class)
    @Transform(value=ParseImages.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Image> list();

    @Named(value="Images:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/images")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseImages.class)
    @Transform(value=ParseImages.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Image> list(ListOptions var1);
}

