/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import java.net.URI;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.functions.internal.PATCH;
import org.jclouds.googlecomputeengine.functions.internal.ParseFirewalls;
import org.jclouds.googlecomputeengine.handlers.FirewallBinder;
import org.jclouds.googlecomputeengine.options.FirewallOptions;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticator;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticator.class})
public interface FirewallApi {
    @Named(value="Firewalls:get")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/firewalls/{firewall}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Firewall get(@PathParam(value="firewall") String var1);

    @Named(value="Firewalls:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/global/firewalls")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=FirewallBinder.class)
    public Operation createInNetwork(@PayloadParam(value="name") String var1, @PayloadParam(value="network") URI var2, @PayloadParam(value="options") FirewallOptions var3);

    @Named(value="Firewalls:update")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/global/firewalls/{firewall}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    public Operation update(@PathParam(value="firewall") String var1, @BinderParam(value=BindToJsonPayload.class) FirewallOptions var2);

    @Named(value="Firewalls:patch")
    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/global/firewalls/{firewall}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    public Operation patch(@PathParam(value="firewall") String var1, @BinderParam(value=BindToJsonPayload.class) FirewallOptions var2);

    @Named(value="Firewalls:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/global/firewalls/{firewall}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Operation delete(@PathParam(value="firewall") String var1);

    @Named(value="Firewalls:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/firewalls")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseFirewalls.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Firewall> listFirstPage();

    @Named(value="Firewalls:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/firewalls")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseFirewalls.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Firewall> listAtMarker(@QueryParam(value="pageToken") @Nullable String var1);

    @Named(value="Firewalls:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/firewalls")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseFirewalls.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Firewall> listAtMarker(@QueryParam(value="pageToken") @Nullable String var1, ListOptions var2);

    @Named(value="Firewalls:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/firewalls")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseFirewalls.class)
    @Transform(value=ParseFirewalls.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Firewall> list();

    @Named(value="Firewalls:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/global/firewalls")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseFirewalls.class)
    @Transform(value=ParseFirewalls.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Firewall> list(ListOptions var1);
}

