/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.googlecomputeengine.domain.Address;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.functions.internal.ParseAddresses;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.filters.OAuthAuthenticator;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthAuthenticator.class})
public interface AddressApi {
    @Named(value="Addresss:get")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/regions/{region}/addresses/{address}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Address getInRegion(@PathParam(value="region") String var1, @PathParam(value="address") String var2);

    @Named(value="Addresss:insert")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/regions/{region}/addresses")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation createInRegion(@PathParam(value="region") String var1, @PayloadParam(value="name") String var2);

    @Named(value="Addresss:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/regions/{region}/addresses/{address}")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation deleteInRegion(@PathParam(value="region") String var1, @PathParam(value="address") String var2);

    @Named(value="Addresss:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/regions/{region}/addresses")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseAddresses.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Address> listFirstPageInRegion(@PathParam(value="region") String var1);

    @Named(value="Addresss:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/regions/{region}/addresses")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseAddresses.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Address> listAtMarkerInRegion(@PathParam(value="region") String var1, @QueryParam(value="pageToken") @Nullable String var2);

    @Named(value="Addresss:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/regions/{region}/addresses")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseAddresses.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public ListPage<Address> listAtMarkerInRegion(@PathParam(value="region") String var1, @QueryParam(value="pageToken") @Nullable String var2, ListOptions var3);

    @Named(value="Addresss:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/regions/{region}/addresses")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseAddresses.class)
    @Transform(value=ParseAddresses.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Address> listInRegion(@PathParam(value="region") String var1);

    @Named(value="Addresss:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/regions/{region}/addresses")
    @OAuthScopes(value={"https://www.googleapis.com/auth/compute.readonly"})
    @ResponseParser(value=ParseAddresses.class)
    @Transform(value=ParseAddresses.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Address> listInRegion(@PathParam(value="region") String var1, ListOptions var2);
}

