/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import org.jclouds.googlecomputeengine.domain.Quota;
import org.jclouds.googlecomputeengine.domain.Resource;
import org.jclouds.javax.annotation.Nullable;

@Beta
public final class Region
extends Resource {
    private final Status status;
    private final Set<URI> zones;
    private final Set<Quota> quotas;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "status", "zones", "quotas"})
    private Region(String id, Date creationTimestamp, URI selfLink, String name, String description, Status status, Set<URI> zones, Set<Quota> quotas) {
        super(Resource.Kind.REGION, id, creationTimestamp, selfLink, name, description);
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (String)"status of %name", (Object[])new Object[]{name}));
        this.zones = zones == null ? ImmutableSet.of() : ImmutableSet.copyOf(zones);
        this.quotas = quotas == null ? ImmutableSet.of() : ImmutableSet.copyOf(quotas);
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public Set<URI> getZones() {
        return this.zones;
    }

    public Set<Quota> getQuotas() {
        return this.quotas;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("status", (Object)this.status).add("zones", this.zones).add("quotas", this.quotas);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromRegion(this);
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private Status status;
        private ImmutableSet.Builder<URI> zones = ImmutableSet.builder();
        private ImmutableSet.Builder<Quota> quotas = ImmutableSet.builder();

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder zone(URI zone) {
            this.zones.add(Preconditions.checkNotNull((Object)zone, (Object)"zone"));
            return this;
        }

        public Builder zones(Set<URI> zones) {
            this.zones.addAll((Iterable)Preconditions.checkNotNull(zones, (Object)"zones"));
            return this;
        }

        public Builder addQuota(String metric, double usage, double limit) {
            this.quotas.add((Object)Quota.builder().metric(metric).usage(usage).limit(limit).build());
            return this;
        }

        public Builder quotas(Set<Quota> quotas) {
            this.quotas.addAll((Iterable)Preconditions.checkNotNull(quotas));
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Region build() {
            return new Region(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.status, (Set)this.zones.build(), (Set)this.quotas.build());
        }

        public Builder fromRegion(Region in) {
            return ((Builder)super.fromResource(in)).status(in.getStatus()).zones(in.getZones()).quotas(in.getQuotas());
        }
    }

    public static enum Status {
        UP,
        DOWN;

    }
}

