/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import org.jclouds.googlecomputeengine.domain.Resource;

@Beta
public final class Network
extends Resource {
    private final String IPv4Range;
    private final Optional<String> gatewayIPv4;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "IPv4Range", "gatewayIPv4"})
    protected Network(String id, Date creationTimestamp, URI selfLink, String name, String description, String IPv4Range, String gatewayIPv4) {
        super(Resource.Kind.NETWORK, id, creationTimestamp, selfLink, name, description);
        this.IPv4Range = (String)Preconditions.checkNotNull((Object)IPv4Range);
        this.gatewayIPv4 = Optional.fromNullable((Object)gatewayIPv4);
    }

    public String getIPv4Range() {
        return this.IPv4Range;
    }

    public Optional<String> getGatewayIPv4() {
        return this.gatewayIPv4;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("IPv4Range", (Object)this.IPv4Range).add("gatewayIPv4", this.gatewayIPv4.orNull());
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromNetwork(this);
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private String IPv4Range;
        private String gatewayIPv4;

        public Builder IPv4Range(String IPv4Range) {
            this.IPv4Range = IPv4Range;
            return this;
        }

        public Builder gatewayIPv4(String gatewayIPv4) {
            this.gatewayIPv4 = gatewayIPv4;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Network build() {
            return new Network(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.IPv4Range, this.gatewayIPv4);
        }

        public Builder fromNetwork(Network in) {
            return (Builder)super.fromResource(in);
        }
    }
}

