/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.Resource;

@Beta
public final class MachineType
extends Resource {
    private final Integer guestCpus;
    private final Integer memoryMb;
    private final Integer imageSpaceGb;
    private final List<ScratchDisk> scratchDisks;
    private final Integer maximumPersistentDisks;
    private final Long maximumPersistentDisksSizeGb;
    private final String zone;

    @ConstructorProperties(value={"id", "creationTimestamp", "selfLink", "name", "description", "guestCpus", "memoryMb", "imageSpaceGb", "scratchDisks", "maximumPersistentDisks", "maximumPersistentDisksSizeGb", "zone"})
    private MachineType(String id, Date creationTimestamp, URI selfLink, String name, String description, int guestCpus, int memoryMb, int imageSpaceGb, List<ScratchDisk> scratchDisks, int maximumPersistentDisks, long maximumPersistentDisksSizeGb, String zone) {
        super(Resource.Kind.MACHINE_TYPE, id, creationTimestamp, selfLink, name, description);
        this.guestCpus = (Integer)Preconditions.checkNotNull((Object)guestCpus, (String)"guestCpus of %s", (Object[])new Object[]{name});
        this.memoryMb = (Integer)Preconditions.checkNotNull((Object)memoryMb, (String)"memoryMb of %s", (Object[])new Object[]{name});
        this.imageSpaceGb = (Integer)Preconditions.checkNotNull((Object)imageSpaceGb, (String)"imageSpaceGb of %s", (Object[])new Object[]{name});
        this.scratchDisks = scratchDisks == null ? ImmutableList.of() : scratchDisks;
        this.maximumPersistentDisks = (Integer)Preconditions.checkNotNull((Object)maximumPersistentDisks, (String)"maximumPersistentDisks of %s", (Object[])new Object[]{name});
        this.maximumPersistentDisksSizeGb = maximumPersistentDisksSizeGb;
        this.zone = (String)Preconditions.checkNotNull((Object)zone, (String)"zone of %s", (Object[])new Object[]{name});
    }

    public int getGuestCpus() {
        return this.guestCpus;
    }

    public int getMemoryMb() {
        return this.memoryMb;
    }

    public int getImageSpaceGb() {
        return this.imageSpaceGb;
    }

    public List<ScratchDisk> getScratchDisks() {
        return this.scratchDisks;
    }

    public int getMaximumPersistentDisks() {
        return this.maximumPersistentDisks;
    }

    public long getMaximumPersistentDisksSizeGb() {
        return this.maximumPersistentDisksSizeGb;
    }

    public String getZone() {
        return this.zone;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MachineType that = (MachineType)MachineType.class.cast(obj);
        return Objects.equal((Object)((Object)this.kind), (Object)((Object)that.kind)) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.zone, (Object)that.zone);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("guestCpus", (Object)this.guestCpus).add("memoryMb", (Object)this.memoryMb).add("imageSpaceGb", (Object)this.imageSpaceGb).add("scratchDisks", this.scratchDisks).add("maximumPersistentDisks", (Object)this.maximumPersistentDisks).add("maximumPersistentDisksSizeGb", (Object)this.maximumPersistentDisksSizeGb).add("zone", (Object)this.zone);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromMachineType(this);
    }

    public static final class ScratchDisk {
        private final int diskGb;

        @ConstructorProperties(value={"diskGb"})
        private ScratchDisk(int diskGb) {
            this.diskGb = diskGb;
        }

        public int getDiskGb() {
            return this.diskGb;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.diskGb});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ScratchDisk that = (ScratchDisk)ScratchDisk.class.cast(obj);
            return Objects.equal((Object)this.diskGb, (Object)that.diskGb);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).add("diskGb", this.diskGb);
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return ScratchDisk.builder().fromScratchDisk(this);
        }

        public static class Builder {
            private int diskGb;

            public Builder diskGb(int diskGb) {
                this.diskGb = diskGb;
                return this;
            }

            public ScratchDisk build() {
                return new ScratchDisk(this.diskGb);
            }

            public Builder fromScratchDisk(ScratchDisk in) {
                return new Builder().diskGb(in.getDiskGb());
            }
        }
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private Integer guestCpus;
        private Integer memoryMb;
        private Integer imageSpaceGb;
        private ImmutableList.Builder<ScratchDisk> scratchDisks = ImmutableList.builder();
        private Integer maximumPersistentDisks;
        private Long maximumPersistentDisksSizeGb;
        private String zone;

        public Builder guestCpus(int guesCpus) {
            this.guestCpus = guesCpus;
            return this;
        }

        public Builder memoryMb(int memoryMb) {
            this.memoryMb = memoryMb;
            return this;
        }

        public Builder imageSpaceGb(int imageSpaceGb) {
            this.imageSpaceGb = imageSpaceGb;
            return this;
        }

        public Builder addScratchDisk(int diskGb) {
            this.scratchDisks.add((Object)ScratchDisk.builder().diskGb(diskGb).build());
            return this;
        }

        public Builder scratchDisks(List<ScratchDisk> scratchDisks) {
            this.scratchDisks.addAll(scratchDisks);
            return this;
        }

        public Builder maximumPersistentDisks(int maximumPersistentDisks) {
            this.maximumPersistentDisks = maximumPersistentDisks;
            return this;
        }

        public Builder maximumPersistentDisksSizeGb(long maximumPersistentDisksSizeGb) {
            this.maximumPersistentDisksSizeGb = maximumPersistentDisksSizeGb;
            return this;
        }

        public Builder zone(String zone) {
            this.zone = zone;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MachineType build() {
            return new MachineType(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.guestCpus, this.memoryMb, this.imageSpaceGb, (List)this.scratchDisks.build(), this.maximumPersistentDisks, this.maximumPersistentDisksSizeGb, this.zone);
        }

        public Builder fromMachineType(MachineType in) {
            return ((Builder)super.fromResource(in)).memoryMb(in.getMemoryMb()).imageSpaceGb(in.getImageSpaceGb()).scratchDisks(in.getScratchDisks()).maximumPersistentDisks(in.getMaximumPersistentDisks()).maximumPersistentDisksSizeGb(in.getMaximumPersistentDisksSizeGb()).zone(in.getZone());
        }
    }
}

