/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Project;
import org.jclouds.googlecomputeengine.domain.SlashEncodedIds;
import org.jclouds.googlecomputeengine.handlers.GoogleComputeEngineErrorHandler;
import org.jclouds.googlecomputeengine.predicates.GlobalOperationDonePredicate;
import org.jclouds.googlecomputeengine.predicates.RegionOperationDonePredicate;
import org.jclouds.googlecomputeengine.predicates.ZoneOperationDonePredicate;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.Uris;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.FirstZone;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

@ConfiguresHttpApi
public class GoogleComputeEngineHttpApiModule
extends HttpApiModule<GoogleComputeEngineApi> {
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Predicate<AtomicReference<Operation>>>(){}).annotatedWith((Annotation)Names.named((String)"global")).to(GlobalOperationDonePredicate.class);
        this.bind((TypeLiteral)new TypeLiteral<Predicate<AtomicReference<Operation>>>(){}).annotatedWith((Annotation)Names.named((String)"region")).to(RegionOperationDonePredicate.class);
        this.bind((TypeLiteral)new TypeLiteral<Predicate<AtomicReference<Operation>>>(){}).annotatedWith((Annotation)Names.named((String)"zone")).to(ZoneOperationDonePredicate.class);
        this.bind(ImplicitLocationSupplier.class).to(FirstZone.class).in(Scopes.SINGLETON);
        super.configure();
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(GoogleComputeEngineErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(GoogleComputeEngineErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(GoogleComputeEngineErrorHandler.class);
    }

    @Provides
    @Singleton
    @UserProject
    public Supplier<String> supplyProject(@Provider Supplier<Credentials> creds, final GoogleComputeEngineApi api, AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, (Supplier)Suppliers.compose((Function)new Function<Credentials, String>(){

            public String apply(Credentials in) {
                String projectName = in.identity;
                if (projectName.indexOf("@") != -1 && (projectName = (String)Iterables.get((Iterable)Splitter.on((String)"@").split((CharSequence)projectName), (int)0)).indexOf("-") != -1) {
                    projectName = (String)Iterables.get((Iterable)Splitter.on((String)"-").split((CharSequence)projectName), (int)0);
                }
                Project project = api.getProjectApi().get(projectName);
                return project.getName();
            }
        }, creds), (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Named(value="machineTypeToURI")
    public Function<String, URI> provideMachineTypeNameToURIFunction(final @Provider Supplier<URI> endpoint, final @UserProject Supplier<String> userProject) {
        return new Function<String, URI>(){

            public URI apply(String input) {
                SlashEncodedIds slashEncodedIds = SlashEncodedIds.fromSlashEncoded(input);
                return Uris.uriBuilder((URI)((URI)endpoint.get())).appendPath("/projects/").appendPath((String)userProject.get()).appendPath("/zones/").appendPath(slashEncodedIds.getFirstId()).appendPath("/machineTypes/").appendPath(slashEncodedIds.getSecondId()).build();
            }
        };
    }

    @Provides
    @Singleton
    @Named(value="networkToURI")
    public Function<String, URI> provideNetworkNameToURIFunction(final @Provider Supplier<URI> endpoint, final @UserProject Supplier<String> userProject) {
        return new Function<String, URI>(){

            public URI apply(String input) {
                return Uris.uriBuilder((URI)((URI)endpoint.get())).appendPath("/projects/").appendPath((String)userProject.get()).appendPath("/global/networks/").appendPath(input).build();
            }
        };
    }

    @Provides
    @Singleton
    @Named(value="zoneToURI")
    public Function<String, URI> provideZoneNameToURIFunction(final @Provider Supplier<URI> endpoint, final @UserProject Supplier<String> userProject) {
        return new Function<String, URI>(){

            public URI apply(String input) {
                return Uris.uriBuilder((URI)((URI)endpoint.get())).appendPath("/projects/").appendPath((String)userProject.get()).appendPath("/zones/").appendPath(input).build();
            }
        };
    }

    @Provides
    @Singleton
    @Named(value="regionToURI")
    public Function<String, URI> provideRegionNameToURIFunction(final @Provider Supplier<URI> endpoint, final @UserProject Supplier<String> userProject) {
        return new Function<String, URI>(){

            public URI apply(String input) {
                return Uris.uriBuilder((URI)((URI)endpoint.get())).appendPath("/projects/").appendPath((String)userProject.get()).appendPath("/regions/").appendPath(input).build();
            }
        };
    }
}

