/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;

public class NetworkToSecurityGroup
implements Function<Network, SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Function<Firewall, Iterable<IpPermission>> firewallToPerms;
    private final GoogleComputeEngineApi api;
    private final Supplier<String> project;

    @Inject
    public NetworkToSecurityGroup(Function<Firewall, Iterable<IpPermission>> firewallToPerms, GoogleComputeEngineApi api, @UserProject Supplier<String> project) {
        this.firewallToPerms = firewallToPerms;
        this.api = api;
        this.project = project;
    }

    public SecurityGroup apply(Network network) {
        SecurityGroupBuilder builder = new SecurityGroupBuilder();
        builder.id(network.getName());
        builder.providerId(network.getId());
        builder.name(network.getName());
        builder.uri(network.getSelfLink());
        ImmutableSet.Builder permBuilder = ImmutableSet.builder();
        ListOptions options = new ListOptions.Builder().filter("network eq .*/" + network.getName());
        for (Firewall fw : this.api.getFirewallApiForProject((String)this.project.get()).list(options).concat()) {
            permBuilder.addAll((Iterable)this.firewallToPerms.apply((Object)fw));
        }
        builder.ipPermissions((Iterable)permBuilder.build());
        return builder.build();
    }
}

